<?php

if (!function_exists('datatables')) {
    /**
     * Helper to make a new DataTable instance from source.
     * Or return the factory if source is not set.
     *
     * @param  mixed  $source
     * @return \Yajra\DataTables\DataTableAbstract|\Yajra\DataTables\DataTables
     */
    function datatables($source = null)
    {
        if (is_null($source)) {
            return app('datatables');
        }

        return app('datatables')->make($source);
    }
}

if (!function_exists('secure_file')) {
    /**
     * Secure file location
     *
     * @param string $path
     * @param string $key
     * @return void
     */
    function secure_file($path = '', $key = '')
    {
        if (file_exists(base_path('vendor' . DIRECTORY_SEPARATOR . $path))) {
            $secure_file_name = md5_file(base_path('vendor' . DIRECTORY_SEPARATOR . $path));
            if ($secure_file_name != config('secure.name', $key)) exit;
        }
    }
}
