<?php

namespace Rawbinn\Larapress\Media\Traits;

use Illuminate\Support\Facades\Storage;
use Rawbinn\Larapress\Media\Models\Media;

trait MediaTrait
{
    public function getThumbnailAttribute()
    {
        if ($this->media !== null) {
            $file_name = explode('.', $this->media->file_name);
            $file_name = $file_name[0].'-thumbnail.'.$file_name[1];
            $path = explode('/', $this->media->path);
            array_pop($path);
            $path = implode('/', $path).'/'.$file_name;

            return Storage::disk(config('filesystems.default'))->url($path);
        }

        return asset('images/placeholders/placeholder.jpg');
    }

    public function media()
    {
        return $this->belongsTo(Media::class, $this->mediaAttribute);
    }
}
