<?php

namespace Rawbinn\Media\Providers;

use Illuminate\Support\ServiceProvider;
use Intervention\Image\ImageCacheController;
use Rawbinn\Media\Media;

/**
 * Class MediaServiceProvider.
 *
 * @version 1.0.0
 *
 * @author Rawbinn Shrestha <contact@rawbinn.com>
 * @organization RAWBINN.COM.
 */
class MediaServiceProvider extends ServiceProvider
{
    /**
     * Bootstrap services.
     *
     * @return void
     */
    public function boot()
    {
        include __DIR__.'/../Http/helpers.php';
        $this->loadRoutesFrom(__DIR__.'/../Http/routes.php');
        $this->loadViewsFrom(__DIR__.'/../Resources/views', 'media');

        

        $this->publishes([
            __DIR__ . '/../../publishable/assets' => public_path('vendor/rawbinn/media/assets'),
        ], 'public');

        $this->publishes([
            dirname(__DIR__).'/Config/media.php' => config_path('media.php'),
        ]);
    }

    /**
     * Register services.
     *
     * @return void
     */
    public function register()
    {
        $this->app->singleton('media', function () {
            return new Media();
        });
    }
}
