<?php

namespace Rawbinn\Media\Models;

use App\Models\Access\User\User;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Support\Facades\Storage;

/**
 * Class Media.
 *
 * @version 1.0.0
 *
 * @author Rawbinn Shrestha <contact@rawbinn.com>
 * @organization RAWBINN.COM.
 */
class Media extends Model
{
    protected $table;

    protected $fillable = [
        'file_original_name',
        'file_name',
        'path',
        'user_id',
        'file_size',
        'extension',
        'type',
        'groups'
    ];

    /**
     * The accessors to append to the model's array form.
     *
     * @var array
     */
    protected $appends = ['url'];

    public function __construct(array $attributes = [])
    {
        parent::__construct($attributes);
        $this->table = config('media.table') ?? 'media';
    }

    public function user()
    {
        return $this->belongsTo(User::class);
    }

    /**
     * @return mixed
     *
     * @author Rawbinn Shrestha ( rawbinnn@gmail.com )
     */
    public function getUrlAttribute()
    {
        return public_asset('storage/'.str_replace('\\', '/', $this->path));
    }

    public function size($size)
    {
        $file_name = explode('.', $this->file_name);
        $file_name = $file_name[0].'-'.$size.'.'.$file_name[1];
        $path = explode('/', $this->path);
        array_pop($path);
        $path = implode('/', $path).'/'.$file_name;

        return Storage::disk(config('filesystems.default'))->url($path);
    }
}
