<?php

namespace Rawbinn\Larapress\Media;

use Illuminate\Support\Facades\Storage;
use Intervention\Image\Facades\Image;
use Intervention\Image\ImageCacheController;

/**
 * Class Media
 * @package Seshra\Media
 * @version 1.0.0
 * @author Rawbinn Shrestha <contact@rawbinn.com>
 * @organization RAWBINN.COM.
 */
class Media extends ImageCacheController
{

    public function cache($path, $dimensions = null)
    {
        if($dimensions === null) {
            return $this->buildResponse(Storage::get($path));
        }
        $dimensions = preg_split('/x|X+/', $dimensions);
        if(count($dimensions) == 2) {
            $content = Image::cache(function($image) use ($path, $dimensions) {
                return $image->make(Storage::path($path))->resize($dimensions[0], $dimensions[1]);
             }, config('imagecache.lifetime', 1440));
             return $this->buildResponse($content);
        }
        return $this->buildResponse(Storage::get($path));
    }
}