<?php

use Illuminate\Support\Facades\Config;
use Illuminate\Support\Facades\Storage;
use Seshra\Media\Facades\Media as Media;

if (!function_exists('media')) {
    /**
     * @param [string] small | medium | large | original |200x200
     */
    function media($id, $dimensions = '')
    {
        if (($media = \Seshra\Media\Models\Media::find($id)) != null) {
            $path = str_replace('\\', '/', $media->path);

            if (in_array($dimensions, ['small', 'medium', 'large', 'original'])) {
                return url('cache/'.$dimensions.'/'.$path);
            }
            if ($dimensions != '') {
                return url('image/'.$path.'/'.$dimensions);
            }

            return Storage::disk(config('filesystems.default'))->url($path);
        }

        return $dimensions ? asset('images/placeholders/placeholder'.$dimensions.'.webp') : asset('images/placeholders/placeholder.webp');
    }
}
