<?php namespace Rawbinn\Larapress\Middleware;

use Error;
use Closure;
use Exception;
use Illuminate\Http\Request;
use Rawbinn\Larapress\LarapressResponse;
use Illuminate\Contracts\Container\Container;
use Illuminate\Contracts\Debug\ExceptionHandler;
use Symfony\Component\Debug\Exception\FatalThrowableError;

/**
 * Class Larapress
 * @package Rawbinn\Larapress\Middleware
 * @author Rawbinn Shrestha <rawbinnn@gmail.com>
 */
class Larapress
{
    /**
     * The App container
     *
     * @var Container
     */
    protected $container;

    /**
     * The Larapress Response
     *
     * @var Larapress
     */
    protected $larapress;

    /**
     * Create a new middleware instance.
     *
     * @param  Container $container
     */
    public function __construct(Container $container, LarapressResponse $larapress)
    {
        $this->container = $container;
        $this->larapress = $larapress;
    }

    /**
     * Handle an incoming request.
     *
     * @param  Request  $request
     * @param  Closure  $next
     * @return mixed
     */
    public function handle($request, Closure $next)
    {
        try {
            /** @var \Illuminate\Http\Response $response */
            $response = $next($request);
        } catch (Exception $e) {
            $response = $this->handleException($request, $e);
        } catch (Error $error) {
            $e = new FatalThrowableError($error);
            $response = $this->handleException($request, $e);
        }

        // Modify the response to add the Debugbar
        $this->larapress->modifyResponse($request, $response);

        return $response;

    }

    /**
     * Handle the given exception.
     *
     * (Copy from Illuminate\Routing\Pipeline by Taylor Otwell)
     *
     * @param $passable
     * @param  Exception $e
     * @return mixed
     * @throws Exception
     */
    protected function handleException($passable, Exception $e)
    {
        if (!$this->container->bound(ExceptionHandler::class) || !$passable instanceof Request) {
            throw $e;
        }

        $handler = $this->container->make(ExceptionHandler::class);

        $handler->report($e);

        return $handler->render($passable, $e);
    }
}
