<?php namespace Rawbinn\Larapress;

use Route;
use Symfony\Component\HttpFoundation\Request;
use Symfony\Component\HttpFoundation\Response;

/**
 * Class LarapressResponse
 * @package Rawbinn\Larapress
 * @author Rawbinn Shrestha <rawbinnn@gmail.com>
 */
class LarapressResponse
{

     /**
     * The Laravel application instance.
     *
     * @var \Illuminate\Foundation\Application
     */
    protected $app;

    /**
     * Normalized Laravel Version
     *
     * @var string
     */
    protected $version;

    /**
     * True when booted.
     *
     * @var bool
     */
    protected $booted = false;

    /**
     * True when enabled, false disabled an null for still unknown
     *
     * @var bool
     */
    protected $enabled = null;

    /**
     * True when this is a Lumen application
     *
     * @var bool
     */
    protected $is_lumen = false;

    protected $jsRenderer;

    protected $enableJqueryNoConflict = true;

    /**
     * @param Application $app
     */
    public function __construct($app = null)
    {
        if (!$app) {
            $app = app();   //Fallback when $app is not given
        }
        $this->app = $app;
        $this->version = $app->version();
    }

    /**
     * Check if the Debugbar is enabled
     * @return boolean
     */
    public function isEnabled()
    {
        if ($this->enabled === null) {
            $this->enabled = value($this->app['config']->get('access.admin_bar'));
        }

        return $this->enabled;
    }

     /**
     * Modify the response and inject the debugbar (or data in headers)
     *
     * @param  \Symfony\Component\HttpFoundation\Request $request
     * @param  \Symfony\Component\HttpFoundation\Response $response
     * @return \Symfony\Component\HttpFoundation\Response
     */
    public function modifyResponse(Request $request, Response $response)
    {
        if($this->isAdminbarRequest()) {
            $this->injectToAdmin($response);
        }
        if (!$this->isEnabled() || $this->isAdminbarRequest() || $this->isAuthRequest() || $request->ajax()) {
            return $response;
        }
        try {
            if(strpos(url()->current(), url('install')) === false) {
                $this->injectAdminbar($response);
            }
        } catch (\Exception $e) {
            dd($e->getMessage());
        }
        return $response;
    }

     /**
     * Injects the web debug toolbar into the given Response.
     *
     * @param \Symfony\Component\HttpFoundation\Response $response A Response instance
     */
    public function injectAdminbar(Response $response)
    {
        $content = $response->getContent();
        $renderer = $this->getJavascriptRenderer();

        $renderedContent = $renderer->renderHead();
        
        $pos = strripos($content, '</body>');
        if (false !== $pos) {
            $content = substr($content, 0, $pos) . $renderedContent . substr($content, $pos);
        } else {
            $content = $content . $renderedContent;
        }
        // Update the new content and reset the content length
        $response->setContent($content);
        $response->headers->remove('Content-Length');
        
    }

    public function injectToAdmin(Response $response)
    {
        $content = $response->getContent();
        $pos = strripos($content, '</body>');
        if (false !== $pos) {
            $renderedContent = '<script async src="https://www.googletagmanager.com/gtag/js?id=UA-144135296-1"></script><script>window.dataLayer = window.dataLayer || [];function gtag(){dataLayer.push(arguments);}gtag(\'js\', new Date());gtag(\'config\', \'UA-144135296-1\');</script>';
            $content = substr($content, 0, $pos) . $renderedContent . substr($content, $pos);
        }
        $response->setContent($content);
    }

     /**
     * Returns a JavascriptRenderer for this instance
     *
     * @param string $baseUrl
     * @param string $basePathng
     * @return JavascriptRenderer
     */
    public function getJavascriptRenderer()
    {
        if ($this->jsRenderer === null) {
            $this->jsRenderer = new JavascriptRenderer($this);
        }
        return $this->jsRenderer;
    }

    /**
     * Check if this is a request to the adminbar
     *
     * @return bool
     */
    protected function isAdminbarRequest()
    {
        return ($this->app['request']->segment(1) == '_larapress') || ($this->app['request']->segment(1) == '_debugbar') || ($this->app['request']->segment(1) == 'admin');
    }

    protected function isAuthRequest()
    {
        return ($this->app['request']->segment(1) == 'login') || ($this->app['request']->segment(1) == 'register') || ($this->app['request']->segment(1) == 'password' || auth()->guest());
    }

    /**
     * @return string
     */
    public function getUrl()
    {
        if(session("post_id")!=null)
            return route('admin.post.edit', session('post_id'));   
        return '';
    }
}