<?php namespace Rawbinn\Larapress\Controllers;

use Illuminate\Http\Request;
use Illuminate\Routing\Controller;
use Eventy;
use Setting;

/**
 * Class ThemeOptionController
 * @package Rawbinn\Larapress\Controllers
 * @author Rawbinn Shrestha <rawbinnn@gmail.com>
 */
class ThemeOptionController extends Controller
{
    public function index(Request $request)
    {
        $data['lang'] = lang($request->lang);
        $data['options'] = Eventy::filter('register_options', []);
        return view('admin.themes.options', $data);
    }

    public function update(Request $request)
    {
        
        $options = $request->except('_token', 'lang');
        $lang = lang($request->lang);
        if($lang != 'en') {
            foreach($options as $key => $value) {
                Setting::set($key.'_'.$lang, json_encode($value));
            }
        } else {
            foreach($options as $key => $value) {
                Setting::set($key, json_encode($value));
            }
        }
        
        return redirect()->back()->withFlashSuccess('Theme options updated successfully.');
    }
}