<?php namespace Rawbinn\Larapress\Controllers;

use Illuminate\Http\Request;
use Illuminate\Http\Response;
use Rawbinn\Larapress\LarapressResponse;
use Illuminate\Routing\Controller;

/**
 * Class AssetController
 * @package Rawbinn\Larapress\Controllers
 * @author Rawbinn Shrestha <rawbinnn@gmail.com>
 */
class AssetController extends Controller
{
    /**
     * @var LarapressResponse
     */
    protected $larapress;

    /**
     * AssetController constructor.
     * @param Request $request
     * @param LarapressResponse $larapress
     */
    public function __construct(Request $request, LarapressResponse $larapress)
    {
        $this->larapress = $larapress;

        if ($request->hasSession()){
            $request->session()->reflash();
        }
    }

    /**
     * Return the javascript for the Larapress
     *
     * @return \Symfony\Component\HttpFoundation\Response
     */
    public function js()
    {
        $renderer = $this->larapress->getJavascriptRenderer();
        $content = $renderer->dumpAssetsToString('js');
        
        $response = new Response(
            $content, 200, [
                'Content-Type' => 'text/javascript',
            ]
        );
        return $this->cacheResponse($response);
    }

    /**
     * Return the stylesheets for the Debugbar
     *
     * @return \Symfony\Component\HttpFoundation\Response
     */
    public function css()
    {
        $renderer = $this->larapress->getJavascriptRenderer();

        $content = $renderer->dumpAssetsToString('css');
        
        $response = new Response(
            $content, 200, [
                'Content-Type' => 'text/css',
            ]
        );
        return $this->cacheResponse($response);
    }

    /**
     * Cache the response 1 year (31536000 sec)
     */
    protected function cacheResponse(Response $response)
    {
        $response->setSharedMaxAge(31536000);
        $response->setMaxAge(31536000);
        $response->setExpires(new \DateTime('+1 year'));

        return $response;
    }

}
