

<?php $__env->startSection('title', trans('labels.backend.theme.management')); ?>

<?php $__env->startSection('page-header'); ?>
    <h1 style="float:left;">
        <?php echo e(trans('labels.backend.theme.management')); ?>

    </h1>
    <div class="theme-upload">
        <form enctype="multipart/form-data" method="post" action="<?php echo e(route('admin.themes.upload')); ?>">
            <?php echo e(csrf_field()); ?>

            <div class="row">
            <div class="col-md-5">
                <input type="file" name="theme">
            </div>
            <div class="col-md-3">
                <button type="submit" class="btn btn-primary btn-xs">Upload</button>
            </div>
            </div>
        </form>
    </div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('after-styles'); ?>
<style type="text/css">
  .larapress-theme-box img{
    width: 290px;
    height: auto;
    border-radius: 4px;
    box-shadow: 0 1px 3px rgba(0,0,0,.15);
  }
  .larapress-theme-box p{
    line-height: 16px;
  }
  .content{
      clear: both;
  }
  .media-body{
    margin-left: 10px;
  }
</style>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>

<?php echo Form::open(['route' => 'admin.themes.update', 'class' => 'form-horizontal']); ?>

  <div class="row">
    <div class="col-md-8">
        <div class="card">
        <div class="card-header with-border">
          <h3 class="card-title">Theme Settings</h3>
        </div>
          <div class="card-body">
                <div class="media larapress-theme-box">
                    <div class="media-left">
                            <img src="<?php echo e($theme['image']); ?>" alt="<?php echo e($theme['name']); ?>" class="media-object">
                        
                    </div>
                    <div class="media-body">
                        <div class="clearfix">
                            <p class="float-right">
                                <a href="<?php echo e($theme['theme_url']); ?>" class="btn btn-success btn-sm">
                                    View Website
                                </a>
                            </p>

                            <h4 style="margin-top: 0"><?php echo e($theme['name']); ?></h4>
                            <p>Author: <a href="<?php echo e($theme['author_url']); ?>"><?php echo e($theme['author']); ?></a></p>
                            <p>Version: <?php echo e($theme['version']); ?></p>

                            <p><?php echo e($theme['description']); ?></p>
                            
                        </div>
                    </div>
                </div>
          </div>
          <!-- /.card-body -->
        </div>
    </div>
    <div class="col-md-4">
      <div class="card">
        <div class="card-header with-border">
          <h3 class="card-title">Active Theme</h3>
        </div>
        <!-- /.card-header -->
          <div class="card-body">
            <div class="form-group col-md-12">
                  <select class="form-control" name="active_theme">
                  <?php $__currentLoopData = $allThemes; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $themeName): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                      <option value="<?php echo e($themeName); ?>" <?php echo e((setting('theme-active') == $themeName) ? 'selected' : ''); ?>><?php echo e(ucfirst($themeName)); ?></option>
                  <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                  </select>
            </div>
          </div>
          <!-- /.card-body -->
      </div>
    </div>
  </div>
  <div class="row">
    <div class="col-md-12">
      <div class="card">
          <div class="card-body">
            
              <div class="float-right">
                  <?php echo e(Form::submit(trans('buttons.general.crud.update'), ['class' => 'btn btn-success btn-xs'])); ?>

              </div><!--float-right-->

              <div class="clearfix"></div>
          </div><!-- /.card-body -->
      </div><!--box-->
    </div>
  </div>
<?php echo e(Form::close()); ?>

<?php $__env->stopSection(); ?>

<?php $__env->startPush('after-scripts'); ?>

<?php $__env->stopPush(); ?>

<?php echo $__env->make('admin.layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\laragon\www\arkbo\resources\views/admin/themes/index.blade.php ENDPATH**/ ?>