<div class="card dynamic-block" id="<?php echo e(Str::slug(strtolower($name))); ?>">
    <div class="card-header with-border">
        <h3 class="card-title">Block #<?php echo e($loop->iteration ?? $block); ?></h3>
        <div class="card-tools float-right">
            <?php if(isset($page)): ?>
                Sort: #<?php echo e($meta->sort); ?>

                <button type="button" class="btn btn-xs btn-secondary sort-meta-item" data-key="<?php echo e($name); ?>" data-pid="<?php echo e($page->id); ?>" data-sort="up" data-toggle="tooltip" data-placement="top" title="Move block up"><i class="fas fa-arrow-up"></i></button>
                <button type="button" class="btn btn-xs btn-secondary sort-meta-item" data-key="<?php echo e($name); ?>" data-pid="<?php echo e($page->id); ?>" data-sort="down" data-toggle="tooltip" data-placement="top" title="Move block down"><i class="fas fa-arrow-down"></i></button>
                <button type="button" class="btn btn-xs btn-danger delete-block-item" data-pid="<?php echo e($page->id); ?>" data-key="<?php echo e(Str::slug(strtolower($name))); ?>"><i class="fa fa-trash"></i></button>
            <?php else: ?>
                <button type="button" class="btn btn-xs btn-danger delete-block-item" data-key="<?php echo e(Str::slug(strtolower($name))); ?>"><i class="fa fa-trash"></i></button>
            <?php endif; ?>
        </div>
    </div>
    <div class="card-body">
        <div class="row">
        <?php for($i = 1; $i <= $cols; $i++): ?>
            <div class="col-md-<?php echo e($column); ?>">
                <div class="border p-3 dynamic-items-holder">
                    <div class="dynamic-block-items">
                        <?php if(isset($metaitem)): ?>
                            <?php 
                                $col = $i;
                                $posts = $metaitem[$i] ?? [];
                            ?>
                            <?php $__currentLoopData = $posts; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item => $post): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <?php if(isset($post['type']) && $post['type'] == 'title_block'): ?>
                                    <?php echo $__env->make('admin.dynamic_block.title_block', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                                <?php elseif(isset($post['type']) && $post['type'] == 'title_subtitle_block'): ?>
                                    <?php echo $__env->make('admin.dynamic_block.title_subtitle_block', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                                <?php elseif(isset($post['type']) && $post['type'] == 'text_block'): ?>
                                    <?php echo $__env->make('admin.dynamic_block.text_block', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                                <?php elseif(isset($post['type']) && $post['type'] == 'text_block_title'): ?>
                                    <?php echo $__env->make('admin.dynamic_block.text_block_title', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                                <?php elseif(isset($post['type']) && $post['type'] == 'text_block_title_image'): ?>
                                    <?php echo $__env->make('admin.dynamic_block.text_block_title_image', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                                <?php elseif(isset($post['type']) && $post['type'] == 'list_block'): ?>
                                    <?php echo $__env->make('admin.dynamic_block.list_block', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                                <?php endif; ?>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>                            
                        <?php endif; ?>
                    </div>
                    <?php if(default_lang() == $lang): ?>
                    <div class="text-center">
                        <div class="btn-group dropup">
                            <button type="button" class="btn btn-primary">
                                Add Block Item
                            </button>
                            <button type="button" class="btn btn-primary dropdown-toggle dropdown-toggle-split"
                                data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
                                <span class="sr-only">Toggle Dropdown</span>
                            </button>
                            <div class="dropdown-menu" data-item="<?php echo e((isset($posts) && count($posts) > 0) ? max(array_keys($posts))+1 : 1); ?>">
                                <a class="dropdown-item" href="#" data-type="title_block" data-col="<?php echo e($i); ?>" data-cols="<?php echo e($cols); ?>" data-block="<?php echo e($block); ?>">Title</a>
                                <a class="dropdown-item" href="#" data-type="title_subtitle_block" data-col="<?php echo e($i); ?>" data-cols="<?php echo e($cols); ?>" data-block="<?php echo e($block); ?>">Title & Subtitle</a>
                                <a class="dropdown-item" href="#" data-type="text_block" data-col="<?php echo e($i); ?>" data-cols="<?php echo e($cols); ?>" data-block="<?php echo e($block); ?>">Text Block</a>
                                <a class="dropdown-item" href="#" data-type="text_block_with_title" data-col="<?php echo e($i); ?>" data-cols="<?php echo e($cols); ?>" data-block="<?php echo e($block); ?>">Text Block [Title, Content]</a>
                                <a class="dropdown-item" href="#" data-type="text_block_with_title_and_image" data-col="<?php echo e($i); ?>" data-cols="<?php echo e($cols); ?>" data-block="<?php echo e($block); ?>">Text Block [Title, Content, Image]</a>
                                <a class="dropdown-item" href="#" data-type="list_block" data-col="<?php echo e($i); ?>" data-cols="<?php echo e($cols); ?>" data-block="<?php echo e($block); ?>">List Block [Title]</a>
                                
                                
                                
                                
                                
                            </div>
                        </div>
                    </div>
                    <?php endif; ?>
                </div>
            </div>
        <?php endfor; ?>
        </div>
    </div>
</div>
<?php /**PATH C:\laragon\www\arkbo\resources\views/admin/dynamic_block/block.blade.php ENDPATH**/ ?>