
<?php $__env->startSection('content'); ?>
<div class="title-bar">
    <div class="container text-center">
        <h1><?php echo e($page->title()); ?></h1>
        <div class="breadcrumbs">
            <a href="<?php echo e(url('/')); ?>">Home</a> / <a href="<?php echo e(url('blogs')); ?>">Blog & News</a> / <?php echo e($page->title()); ?>

        </div>
    </div>
</div>

<div class="content-page">
    <div class="container">
        <div class="row">
            <div class="col-lg-7">
                <?php if($page->hasFeaturedImage()): ?>
                    <img src="<?php echo e($page->getFeaturedImage()); ?>" class="w-100"> 
                <?php endif; ?>
                <div class="row blog-author-date">
                    <div class="col-md-6">
                        <i class="bi bi-calendar-week-fill"></i> Posted On:  <?php echo e($page->date('F j, Y', 'created')); ?>

                    </div>

                    <div class="col-md-6">
                        <i class="bi bi-person-circle"></i> Posted By: <?php echo e($page->metaByKey('contributor' ) != null ? $page->metaByKey('contributor') : $page->author()); ?> 
                    </div>
                </div>
                
                <?php echo $__env->make('includes.partials.messages', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                <?php echo $page->content(); ?>

                <div class="post-metas">
                    <?php $__currentLoopData = $page->metas()->orderBy('post_meta.sort', 'ASC')->get(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $meta): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <div class="row post-meta-block <?php echo e($meta->key); ?>">
                        <?php for($i = 1; $i <= $meta->pull('cols'); $i++): ?>
                        <div class="col-md-<?php echo e($meta->pull('column', 12)); ?>">
                            <?php $__currentLoopData = $meta->pull('post'); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <?php if($meta->pull('type') == 'title_block'): ?>
                                    <div class="post-meta-item title-block">
                                        <h2 style="text-align: <?php echo e($item[$i]['align'] ?? ''); ?>;"><?php echo e($item[$i]['title'] ?? ''); ?></h2>
                                    </div>
                                <?php elseif($meta->pull('type') == 'title_subtitle_block'): ?>
                                    <div class="post-meta-item title-subtitle-block">
                                        <h2 style="text-align: <?php echo e($item[$i]['align'] ?? ''); ?>;"><?php echo e($item[$i]['title'] ?? ''); ?></h2>
                                        <h3 style="text-align: <?php echo e($item[$i]['align'] ?? ''); ?>;"><?php echo e($item[$i]['subtitle'] ?? ''); ?></h3>
                                    </div>
                                <?php elseif($meta->pull('type') == 'text_block'): ?>
                                    <div class="post-meta-item text-block">
                                        <?php echo $item[$i]['content']; ?>

                                    </div>
                                <?php elseif($meta->pull('type') == 'text_block_with_title'): ?>
                                    <div class="row post-meta text-block-with-title <?php echo e($meta->pull('class')); ?>" id="<?php echo e($meta->pull('id')); ?>">
                                        <div class="col-md-<?php echo e($meta->pull('cols', 12)); ?>">
                                            <div class="post-meta-title"><?php echo e($meta->pull('title')); ?></div>
                                            <div class="post-meta-body">
                                                <?php echo $meta->pull('content'); ?>

                                            </div>
                                        </div>
                                    </div>
                                <?php elseif($meta->pull('type') == 'text_block_title_image'): ?>
                                    <div class="row post-meta text-block-title-image <?php echo e($meta->pull('class')); ?>" id="<?php echo e($meta->pull('id')); ?>">
                                        <div class="col-lg-7">
                                            <div class="post-meta-title"><?php echo e($meta->pull('title')); ?></div>
                                            <div class="post-meta-body">
                                                <?php echo $meta->pull('content'); ?>

                                            </div>
                                        </div>
                                        <div class="col-lg-5">
                                            <img class="post-meta-image" src="<?php echo e(image($meta->pull('featured_image'))); ?>">
                                        </div>
                                    </div>
                                <?php elseif($meta->pull('type') == 'text_list_block'): ?>
                                    <div class="row post-meta text-list-block <?php echo e($meta->pull('class')); ?>"  id="<?php echo e($meta->pull('id')); ?>">
                                        <?php $__currentLoopData = $meta->pull('list'); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <div class="col-lg-<?php echo e($meta->pull('cols', 4)); ?> d-flex">
                                                <div class="meta-list-item">
                                                    <h3 class="post-meta-title"><?php echo e($item['key']); ?></h3>
                                                    <p><?php echo $item['value']; ?></p>
                                                </div>
                                            </div>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </div>
                                <?php elseif($meta->pull('type') == 'text_list_block_image'): ?>
                                    <div class="row post-meta text-list-block-with-image <?php echo e($meta->pull('class')); ?>"  id="<?php echo e($meta->pull('id')); ?>">
                                        <?php $__currentLoopData = $meta->pull('list'); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <div class="col-lg-<?php echo e($meta->pull('cols', 6)); ?> d-flex">
                                                <div class="<?php echo e($meta->pull('class')); ?>  meta-list-item " id="<?php echo e($meta->pull('id')); ?>">
                                                    <div class="row">
                                                        <div class="col-sm-8">
                                                            <h2 class="post-meta-title"><?php echo e($item['key']); ?></h2>
                                                                <p><?php echo $item['value']; ?></p>
                                                            
                                                        </div>
                                                        <div class="col-sm-4 col-9">
                                                            <img src="<?php echo e(image($item['image'])); ?>" class="w-100">
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </div>
                                <?php elseif($meta->pull('type') == 'list_block_with_title_image_url'): ?>
                                    <div class="row post-meta list-block-title-image-url <?php echo e($meta->pull('class')); ?>"  id="<?php echo e($meta->pull('id')); ?>">
                                        <?php $__currentLoopData = $meta->pull('list'); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <div class="col-lg-<?php echo e($meta->pull('cols', 6)); ?> d-flex">
                                                <div class="<?php echo e($meta->pull('class')); ?>  meta-list-item " id="<?php echo e($meta->pull('id')); ?>">
                                                    <a href="<?php echo e($item['url']); ?>">
                                                    <div class="row">
                                                        <div class="col-sm-8">
                                                            <h2 class="post-meta-title"><?php echo e($item['title']); ?></h2>
                                                            
                                                        </div>
                                                        <div class="col-sm-4 col-9">
                                                            <img src="<?php echo e(image($item['image'])); ?>" class="w-100">
                                                        </div>
                                                    </div>
                                                    </a>
                                                </div>
                                            </div>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </div>                     
                                <?php endif; ?>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </div>
                        <?php endfor; ?>
                    </div>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </div>
            </div>

            <div class="col-md-5">
                <div class="blog-side-view">
                    <h2 class="div-subtitle">Latest Posts</h2>
                    <div class="row">
                        <?php $blogs = posts(3)
                        ?>
                        <?php $__currentLoopData = $blogs; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $blog): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <div class="col-md-12">
                            <div class="blog-single-small">
                                <div class="row">
                                    <div class="col-md-4">
                                        <a href="<?php echo e($blog->permalink()); ?>">
                                            <?php if($blog->hasFeaturedImage()): ?>
                                                <img src="<?php echo e($blog->getFeaturedImage()); ?>"> 
                                            <?php endif; ?>
                                        </a>
                                    </div>

                                    <div class="col-md-8">
                                        <div class="row blog-dates">
                                            <div class="col-md-12">
                                                <i class="bi bi-calendar-week-fill"></i> <?php echo e($blog->date('F j, Y', 'created')); ?>

                                            </div>
                                        </div>
                                        <h3><a href="<?php echo e($blog->permalink()); ?>"><?php echo e($blog->title()); ?></a></h3>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('gear::layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH D:\laragon\www\arkbotech.com\public\themes/gear/views/post.blade.php ENDPATH**/ ?>