

<?php $__env->startSection('title', 'Gallery'); ?>

<?php $__env->startSection('after-styles'); ?>

<?php $__env->stopSection(); ?>

<?php $__env->startSection('page-header'); ?>
    <h1>
        Gallery Management
    </h1>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
    <div class="card">
        <div class="card-header with-border">
            <h3 class="card-title">Gallery</h3>

            <div class="card-tools float-right">
                <!-- Include your header buttons  -->
                <?php echo e(link_to_route('admin.gallery.create','New Gallery', [], ['class' => 'btn btn-success btn-xs'])); ?>

            </div><!--card-tools float-right-->
        </div><!-- /.card-header -->

        <div class="card-body">
            <div class="table-responsive">
                <table id="gallery-table" class="table table-condensed table-hover">
                    <thead>
                    <tr>
                        <th><?php echo e(trans('labels.backend.table.id')); ?></th>
                        <th><?php echo e(trans('labels.backend.table.title')); ?></th>
                        <th>Items</th>
                        <th>Shortcode</th>
                        <th><?php echo e(trans('labels.backend.table.created')); ?></th>
                        <th><?php echo e(trans('labels.general.actions')); ?></th>
                    </tr>
                    </thead>
                    <tbody>
                        <?php $__empty_1 = true; $__currentLoopData = $galleries; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $gallery): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                            <tr>
                                <td><?php echo e($gallery->id); ?></td>
                                <td><?php echo e($gallery->title); ?></td>
                                <td><?php echo e($gallery->items()->count()); ?></td>
                                <td>
                                    Shortcode: [gallery key=<?php echo e($gallery->slug); ?>] <a href="#" class="clipboard" data-text="[gallery key=<?php echo e($gallery->slug); ?>]">copy</a>
                                </td>
                                <td><?php echo e($gallery->created_at->diffForHumans()); ?></td>
                                <td><?php echo $gallery->action_buttons; ?></td>
                            </tr>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                        <tr><td colspan="6" class="text-center">No data found...</td></tr>
                        <?php endif; ?>
                    </tbody>
                </table>
                <?php echo $galleries->links(); ?>

            </div><!--table-responsive-->
        </div><!-- /.card-body -->
    </div><!--box-->

<?php $__env->stopSection(); ?>

<?php $__env->startPush('after-scripts'); ?>
<script>
    $(document).on('click', '.clipboard', function(e) {
       var _this = $(this);
       var text = $(this).data('text');
       navigator.clipboard.writeText(text).then(() => {
           _this.text('copied');
       });
   });
</script>
<?php $__env->stopPush(); ?>

<?php echo $__env->make('admin.layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/asianelearning/public_html/resources/views/admin/gallery/index.blade.php ENDPATH**/ ?>