

<?php $__env->startSection('title',$labels['name'] ?? $label); ?>

<?php $__env->startSection('page-header'); ?>
    <h1>
        <?php echo e($label ?? 'Item'); ?>

        <small>Add <?php echo e($label); ?></small>
    </h1>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('after-styles'); ?>

<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
    <?php echo e(Form::open(['route' => ['admin.custom.post.type.store', $post_type], 'role' => 'form', 'method' => 'post', 'id' => 'postForm'])); ?>

    <div class="row">
        <div class="col-md-8">
            <div class="card">
                <div class="card-header with-border">
                    <h3 class="card-title">Add <?php echo e($label); ?></h3>
                </div><!-- /.card-header -->

                <div class="card-body">
                    <?php if( array_key_exists('title', $supports)): ?>
                    <div class="form-group">
                        <?php echo e(Form::label('title', $supports['title'])); ?>

                        <?php echo e(Form::text('title', null, ['class' => 'form-control','placeholder' => $supports['title']])); ?>

                    </div>
                    <?php endif; ?>
                    <?php if( array_key_exists('subtitle', $supports)): ?>
                    <div class="form-group">
                        <?php echo e(Form::label('subtitle', $supports['subtitle'])); ?>

                        <?php echo e(Form::textarea('subtitle', null, ['class' => 'form-control seshra-text-editor','data-airmode' => 'true','placeholder' => $supports['subtitle']])); ?>

                    </div>
                    <?php endif; ?>
                    <?php if( array_key_exists('editor', $supports)): ?>
                    <div class="form-group">
                        <label for="content"><?php echo e($supports['editor']); ?></label>
                        <textarea class="seshra-text-editor" name="content" data-min-height="300"
                            data-image-submit-url="<?php echo e(route('admin.image.upload')); ?>" data-format="true"
                            data-image-group="<?php echo e($post_type); ?>"><?php echo old('content'); ?></textarea>
                    </div>
                    <?php endif; ?>
                    <div class="form-group">
                        <label for="meta-title" class="meta-title">Meta Title <small>(Recommended less than 60
                                characters) <span id="meta_title_length"></span></small></label>
                        <?php echo e(Form::text('meta_title', null, ['class' => 'form-control','placeholder' => 'Meta Title','id' => 'meta-title'])); ?>

                    </div>
                    <div class="form-group">
                        <label for="meta-description" class="meta-description">Meta Description <small>(Recommended less
                                than 160 characters) <span id="meta_description_length"></span></small></label>
                        <?php echo e(Form::textarea('meta_description', null, ['class' => 'form-control','rows' => '4','id' => 'meta-description'])); ?>


                    </div>
                </div><!-- /.card-body -->

            </div>
        </div>
        <div class="col-md-4">
            <?php if( array_key_exists('category', $supports)): ?>
            <div class="card">
                <div class="card-header with-border">
                    <h3 class="card-title"><?php echo e($supports['category']); ?></h3>
                </div><!-- /.card-header -->
                <div class="card-body">
                    <div class="form-group">

                        <div id="selectCategory">
                            <ul>
                                <?php echo $__env->make('admin.custom_post.categories',['categories' => $categories], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                            </ul>
                        </div>
                    </div>
                </div>
                <!--form control-->
            </div>
            <?php endif; ?>
            <?php if( array_key_exists('thumbnail', $supports)): ?>
            <div class="card">
                <div class="card-header with-border">
                    <h3 class="card-title"><?php echo e($supports['thumbnail']); ?></h3>
                </div><!-- /.card-header -->

                <div class="card-body">
                    <div class="form-group">
                        <div class="input-group" data-toggle="seshra-uploader" data-type="image" data-group="testimonials">
                            <div class="input-group-prepend">
                                <div class="input-group-text bg-soft-secondary font-weight-medium">Browse</div>
                            </div>
                            <div class="form-control file-amount">Choose File</div>
                            <input type="hidden" name="featured_image" class="selected-files">
                        </div>
                        <div class="file-preview box sm">
                        </div>
                    </div>
                </div><!-- /.card-body -->
            </div>
            <?php endif; ?>
            <!--box-->
            <div class="card position-sticky" style="top: 30px">
                <div class="card-body">
                    <div class="form-group">
                        <?php echo e(Form::submit(trans('buttons.general.save'), ['class' => 'btn btn-success btn-md'])); ?>

                        <input type="submit" name="saveEdit" id="saveEdit" value="Save & Edit"
                            class="btn btn-success btn-md">
                    </div>
                </div>
                <!--form control-->
            </div>
            <!--box-->
        </div>
    </div>
    <?php echo e(Form::close()); ?>

<?php $__env->stopSection(); ?>

<?php $__env->startPush('after-scripts'); ?>
    <script>
        $(function() {
            var type;
           

            $(document).on('click', '#saveEdit', function(e) {
                $("<input>").attr({
                    name: "saveEdit",
                    id: "savenedit",
                    type: "hidden",
                    value: 'saveEdit'
                }).appendTo("#postForm");

                $('#postForm').submit();
            });

            $('#meta-title').on('keyup', function() {
                var length = $(this).val().length;
                if (length > 60) {
                    $('#meta_title_length').addClass('red');
                    $('#meta_title_length').removeClass('green');
                } else {
                    $('#meta_title_length').removeClass('red');
                    $('#meta_title_length').addClass('green');
                }
                $('#meta_title_length').html(length + ' characters');
            });

            $('#meta-description').on('keyup', function() {
                var length = $(this).val().length;
                if (length > 160) {
                    $('#meta_description_length').addClass('red');
                    $('#meta_description_length').removeClass('green');
                } else {
                    $('#meta_description_length').removeClass('red')
                    $('#meta_description_length').addClass('green');;
                }
                $('#meta_description_length').html(length + ' characters');
            });
        });
    </script>
<?php $__env->stopPush(); ?>

<?php echo $__env->make('admin.layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/pnccorgn/stage.pncc.org.np/resources/views/admin/custom_post/create.blade.php ENDPATH**/ ?>