

<?php $__env->startSection('title', 'ThemeOptions'); ?>

<?php $__env->startSection('page-header'); ?>
    <h1 style="float:left;">
        Theme Options
    </h1>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('after-styles'); ?>
<style type="text/css">

.nav-tab-wrapper, .wrap h2.nav-tab-wrapper, h1.nav-tab-wrapper {
    border-bottom: 1px solid #c3c4c7;
    margin: 0;
    padding-top: 9px;
    padding-bottom: 0;
    line-height: inherit;
}
.nav-tab {
    float: left;
    border: 1px solid #c3c4c7;
    border-bottom: none;
    margin-left: .5em;
    padding: 5px 10px;
    font-size: 14px;
    line-height: 1.71428571;
    font-weight: 600;
    background: #dcdcde;
    color: #50575e;
    text-decoration: none;
    white-space: nowrap;
}
.nav-tab-active, .nav-tab:focus:active {
    box-shadow: none;
}
.nav-tab-active {
    margin-bottom: -1px;
    color: #3c434a;
}
.nav-tab-active, .nav-tab-active:focus, .nav-tab-active:focus:active, .nav-tab-active:hover {
    border-bottom: 1px solid #f0f0f1;
    background: #f0f0f1;
    color: #000;
}
.nav-tab-wrapper:not(.wp-clearfix):after {
    content: "";
    display: table;
    clear: both;
}
    /* Options Framework Admin Styles */
    .metabox-holder {
        padding-top: 10px;
    }
    #optionsframework {
        max-width:840px;
        background:#fff;
        border: 1px solid #ddd;
    }
    #optionsframework h3 {
        cursor: default;
        background-color: #f1f1f1;
        border-bottom: 1px solid #ddd;
        padding: 12px 10px;
        margin: 0;
        font-size: 1.3rem;
    }
    #optionsframework p {
        margin-bottom:0;
        padding-bottom:10px;
    }
    #optionsframework .section {
        padding:10px 10px 0;
    }
    #optionsframework .group {
        padding-bottom:40px;
    }
    #optionsframework .section .controls {
        float: left;
        min-width:350px;
        width: 54%;
        padding-right:2%;
    }
    #optionsframework .section .explain {
        max-width:38%;
        float: left;
        font-size: 12px;
        line-height:16px;
        color: #777;
    }
    #optionsframework .section-checkbox .controls {
        width: 98%;
    }
    #optionsframework .section-checkbox .explain {
        max-width:94%;
    }
    #optionsframework .controls input[type=text] {
        width:100%;
    }
    #optionsframework .controls input[type=text].wp-color-picker {
        width: 65px;
    }
    #optionsframework .controls select, #optionsframework .controls textarea {
        margin-bottom:10px;
        width:100%;
    }
    #optionsframework .section-radio label, #optionsframework .section-multicheck label {
        float:left;
        max-width:90%;
        line-height: 16px;
        margin-bottom: 5px;
    }
    #optionsframework input.checkbox, #optionsframework input.of-radio {
        margin: 0 10px 5px 0;
        float:left;
        clear:both;
    }
    #optionsframework .section-typography .controls {
        float:none;
        width:auto;
    }
    #optionsframework .section-typography .explain {
        float:none;
        width:auto;
    }
    #optionsframework .controls .of-typography-size {
        width:80px;
        float:left
    }
    #optionsframework .controls .of-typography-unit {
        width:50px;
        margin-left:5px;
        float:left
    }
    #optionsframework .controls .of-typography-face {
        width:100px;
        margin-left:5px;
        float:left
    }
    #optionsframework .controls .of-typography-style {
        width:80px;
        margin-left:5px;
        margin-right:5px;
        float:left
    }
    #optionsframework .section-typography .wp-picker-container {
        margin-top:2px;
    }
    #optionsframework .of-background-properties {
        clear:both;
        margin-top: 18px;
    }
    #optionsframework .controls .of-background-repeat {
        width:125px;
        margin-right:5px;
        float:left
    }
    #optionsframework .controls .of-background-position {
        width:125px;
        margin-right:5px;
        float:left
    }
    #optionsframework .controls .of-background-attachment {
        width:125px;
        margin-right:5px;
        float:left
    }
    #optionsframework .section-background .wp-picker-container {
        margin-bottom:10px;
    }
    #optionsframework .controls .of-radio-img-img {
        border:3px solid #f9f9f9;
        margin:0 5px 10px 0;
        display:none;
        cursor:pointer;
        float:left;
    }
    #optionsframework .controls .of-radio-img-selected {
        border:3px solid #ccc
    }
    #optionsframework .controls .of-radio-img-img:hover {
        opacity:.8;
    }
    #optionsframework .controls .of-border-width {
        width:80px;
        float:left
    }
    #optionsframework .controls .of-border-style {
        width:120px;
        float:left
    }
    #optionsframework .hide {
        display:none;
    }
    #optionsframework .of-option-image {
        max-width:340px;
        margin:3px 0 18px 0;
    }
    #optionsframework .mini .controls select, #optionsframework .section .mini .controls {
        width: 140px;
    }
    #optionsframework .mini .controls input, #optionsframework .mini .controls {
        min-width:140px;
        width: 140px;
    }
    #optionsframework .mini .explain {
        max-width:74%;
    }

    /* Editor */

    #optionsframework .section-editor .explain {
        max-width: 98%;
        float:none;
        margin-bottom:5px;
    }

    /* Image Uploader */

    #optionsframework .controls input.upload {
        width:80%;
    }
    #optionsframework .screenshot {
        float:left;
        margin-left:1px;
        position:relative;
        width:344px;
        margin-top:3px;
    }
    #optionsframework .screenshot img {
        background:#fafafa;
        border-color:#ccc #eee #eee #ccc;
        border-style:solid;
        border-width:1px;
        float:left;
        max-width:334px;
        padding:4px;
        margin-bottom:10px;
    }
    #optionsframework .screenshot .remove-image {
        background:url("../images/ico-delete.png") no-repeat;
        border:medium none;
        bottom:4px;
        display:block;
        float:left;
        height:16px;
        padding:0;
        position:absolute;
        left:-4px;
        text-indent:-9999px;
        width:16px;
    }
    #optionsframework .screenshot .no_image .file_link {
        margin-left: 20px;
    }
    #optionsframework .screenshot .no_image .remove-button {
        bottom: 0px;
    }
    #optionsframework .reset-button {
        float:left;
        cursor:pointer;
    }

    /* Bottom Section */

    #optionsframework-submit {
        padding: 7px 10px;
        border-top: 1px solid #ddd;
        background-color: #f1f1f1;
    }
    #optionsframework .button-primary {
        float:right;
    }
    #optionsframework .section:after {
        content: "";
        display: table;
    }
    #optionsframework .section:after {
        clear: both;
    }

    #optionsframework .heading {
        font-size: 1rem;
        margin: 1.33rem 0;
    }

    #optionsframework .input-group{
        width: unset;
    }
</style>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('content'); ?>

    <div class="row">
        <div class="col-md-12">
            <div class="card">
                <div class="card-header with-border">
                    <h3 class="card-title">ThemeOptions</h3>
                    <div class="card-tools float-right">
                        <ul class="nav nav-tabs nav-fill border-light">
                            <?php $__currentLoopData = locales(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $locale): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                  <li class="nav-item">
                                      <a class="nav-link text-reset <?php if($locale == $lang ): ?> active <?php else: ?> bg-soft-dark border-light border-left-0 <?php endif; ?> py-3" href="<?php echo e(url()->current()); ?>?lang=<?php echo e($locale); ?>">
                                          <img src="<?php echo e(public_asset('images/flags/'.$locale.'.png')); ?>" height="11" class="mr-1">
                                          <span><?php echo e($locale); ?></span>
                                      </a>
                                  </li>
                              <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </ul>
                    </div>
                </div>
                <div class="card-body">
                    <?php if(count($options) > 0): ?>
                    <div class="metabox-holder">
                        <div id="optionsframework-wrap" class="wrap">

                            <h2 class="nav-tab-wrapper">
                                <?php $counter = 0; ?>
                                <?php $__currentLoopData = $options; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $value): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    
                                    <?php if($value['type'] == 'heading'): ?>
                                        <?php
                                            $counter++;
                                            $class = '';
                                            $class = !empty($value['id']) ? $value['id'] : $value['name'];
                                            $class = preg_replace('/[^a-zA-Z0-9._\-]/', '', strtolower($class)) . '-tab';
                                        ?>
                                        <a id="options-group-<?php echo e($counter); ?>-tab" class="nav-tab <?php echo e($class); ?>"
                                            title="<?php echo e($value['name']); ?>"
                                            href="#options-group-<?php echo e($counter); ?>"><?php echo e($value['name']); ?></a>
                                    <?php endif; ?>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                            </h2>

                            <div id="optionsframework-metabox" class="metabox-holder">
                                <div id="optionsframework" class="postbox">
                                <form action="<?php echo e(route('admin.theme.options')); ?>" method="post">
                                    <?php echo csrf_field(); ?>
                                    <input type="hidden" name="lang" value="<?php echo e($lang); ?>">
                                    <?php 
                                        $option_name = Larapress::option_framework_name();
                                        $counter = 0;
		                                $menu = '';
                                        if($lang != 'en') {
                                            $settings = settings($option_name.'_'.$lang, settings($option_name, []));
                                        } else {
                                            $settings = settings($option_name, []);
                                        }
                                    ?>
                                    <?php $__currentLoopData = $options; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $value): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <?php
                                            $val = '';
                                            $select_value = '';
                                            $output = '';

                                            if($value['type'] == 'hr') {
                                                $class = isset($value['class'])  ? $value['class'] : '';
                                                $output .= '<hr class="'.$class.'" />';
                                                echo $output;
                                                continue;
                                            }

                                            // Wrap all options
                                            if ( ( $value['type'] != "heading" ) && ( $value['type'] != "info" ) ) {

                                                // Keep all ids lowercase with no spaces
                                                $value['id'] = preg_replace('/[^a-zA-Z0-9._\-]/', '', strtolower($value['id']) );

                                                $id = 'section-' . $value['id'];

                                                $class = 'section';
                                                if ( isset( $value['type'] ) ) {
                                                    $class .= ' section-' . $value['type'];
                                                }
                                                if ( isset( $value['class'] ) ) {
                                                    $class .= ' ' . $value['class'];
                                                }

                                                $output .= '<div id="' . esc_attr( $id ) .'" class="' . esc_attr( $class ) . '">'."\n";
                                                if ( isset( $value['name'] ) ) {
                                                    $output .= '<h4 class="heading">' . esc_html( $value['name'] ) . '</h4>' . "\n";
                                                }
                                                if ( $value['type'] != 'editor' ) {
                                                    $output .= '<div class="option">' . "\n" . '<div class="controls">' . "\n";
                                                }
                                                else {
                                                    $output .= '<div class="option">' . "\n" . '<div>' . "\n";
                                                }
                                                
                                            }
                                            // Set default value to $val
                                            if ( isset( $value['std'] ) ) {
                                                $val = $value['std'];
                                            }

                                            // If the option is already saved, override $val
                                            if ( ( $value['type'] != 'heading' ) && ( $value['type'] != 'info') ) {
                                                if ( isset( $settings[($value['id'])]) ) {
                                                    $val = $settings[($value['id'])];
                                                    // Striping slashes of non-array options
                                                    if ( !is_array($val) ) {
                                                        $val = stripslashes( $val );
                                                    }
                                                }
                                            }
                            
                            
                                            // If there is a description save it for labels
                                            $explain_value = '';
                                            if ( isset( $value['desc'] ) ) {
                                                $explain_value = $value['desc'];
                                            }
                            
                                            // Set the placeholder if one exists
                                            $placeholder = '';
                                            if ( isset( $value['placeholder'] ) ) {
                                                $placeholder = ' placeholder="' . esc_attr( $value['placeholder'] ) . '"';
                                            }
                            
                            
                                            switch ( $value['type'] ) {
                                                // Basic text input
                                                case 'text':
                                                    $output .= '<input id="' . esc_attr( $value['id'] ) . '" class="of-input" name="' . esc_attr( $option_name . '[' . $value['id'] . ']' ) . '" type="text" value="' . esc_attr( $val ) . '"' . $placeholder . ' />';
                                                    break;
                                    
                                                // Password input
                                                case 'password':
                                                    $output .= '<input id="' . esc_attr( $value['id'] ) . '" class="of-input" name="' . esc_attr( $option_name . '[' . $value['id'] . ']' ) . '" type="password" value="' . esc_attr( $val ) . '" />';
                                                    break;
                                    
                                                // Textarea
                                                case 'textarea':
                                                    $rows = '8';
                                    
                                                    if ( isset( $value['settings']['rows'] ) ) {
                                                        $custom_rows = $value['settings']['rows'];
                                                        if ( is_numeric( $custom_rows ) ) {
                                                            $rows = $custom_rows;
                                                        }
                                                    }
                                    
                                                    $val = stripslashes( $val );
                                                    $output .= '<textarea id="' . esc_attr( $value['id'] ) . '" class="of-input" name="' . esc_attr( $option_name . '[' . $value['id'] . ']' ) . '" rows="' . $rows . '"' . $placeholder . '>' . esc_textarea( $val ) . '</textarea>';
                                                    break;
                                    
                                                // Select Box
                                                case 'select':
                                                    $output .= '<select class="of-input" name="' . esc_attr( $option_name . '[' . $value['id'] . ']' ) . '" id="' . esc_attr( $value['id'] ) . '">';
                                    
                                                    foreach ($value['options'] as $key => $option ) {
                                                        $output .= '<option'. selected( $val, $key, false ) .' value="' . esc_attr( $key ) . '">' . esc_html( $option ) . '</option>';
                                                    }
                                                    $output .= '</select>';
                                                    break;
                                    
                                    
                                                // Radio Box
                                                case "radio":
                                                    $name = $option_name .'['. $value['id'] .']';
                                                    foreach ($value['options'] as $key => $option) {
                                                        $id = $option_name . '-' . $value['id'] .'-'. $key;
                                                        $output .= '<input class="of-input of-radio" type="radio" name="' . esc_attr( $name ) . '" id="' . esc_attr( $id ) . '" value="'. esc_attr( $key ) . '" '. checked( $val, $key, false) .' /><label for="' . esc_attr( $id ) . '">' . esc_html( $option ) . '</label>';
                                                    }
                                                    break;
                                    
                                                // Image Selectors
                                                case "images":
                                                    $name = $option_name .'['. $value['id'] .']';
                                                    foreach ( $value['options'] as $key => $option ) {
                                                        $selected = '';
                                                        if ( $val != '' && ($val == $key) ) {
                                                            $selected = ' of-radio-img-selected';
                                                        }
                                                        $output .= '<input type="radio" id="' . esc_attr( $value['id'] .'_'. $key) . '" class="of-radio-img-radio" value="' . esc_attr( $key ) . '" name="' . esc_attr( $name ) . '" '. checked( $val, $key, false ) .' />';
                                                        $output .= '<div class="of-radio-img-label">' . esc_html( $key ) . '</div>';
                                                        $output .= '<img src="' . esc_url( $option ) . '" alt="' . $option .'" class="of-radio-img-img' . $selected .'" onclick="document.getElementById(\''. esc_attr($value['id'] .'_'. $key) .'\').checked=true;" />';
                                                    }
                                                    break;
                                    
                                                // Checkbox
                                                case "checkbox":
                                                    $output .= '<input id="' . esc_attr( $value['id'] ) . '" class="checkbox of-input" type="checkbox" name="' . esc_attr( $option_name . '[' . $value['id'] . ']' ) . '" '. checked( $val, 1, false) .' />';
                                                    $output .= '<label class="explain" for="' . esc_attr( $value['id'] ) . '">' . $explain_value . '</label>';
                                                    break;
                                    
                                                // Multicheck
                                                case "multicheck":
                                                    foreach ($value['options'] as $key => $option) {
                                                        $checked = '';
                                                        $label = $option;
                                                        $option = preg_replace('/[^a-zA-Z0-9._\-]/', '', strtolower($key));
                                    
                                                        $id = $option_name . '-' . $value['id'] . '-'. $option;
                                                        $name = $option_name . '[' . $value['id'] . '][' . $option .']';
                                    
                                                        if ( isset($val[$option]) ) {
                                                            $checked = checked($val[$option], 1, false);
                                                        }
                                    
                                                        $output .= '<input id="' . esc_attr( $id ) . '" class="checkbox of-input" type="checkbox" name="' . esc_attr( $name ) . '" ' . $checked . ' /><label for="' . esc_attr( $id ) . '">' . esc_html( $label ) . '</label>';
                                                    }
                                                    break;
                                    
                                                // Color picker
                                                case "color":
                                                    $default_color = '';
                                                    if ( isset($value['std']) ) {
                                                        if ( $val !=  $value['std'] )
                                                            $default_color = ' data-default-color="' .$value['std'] . '" ';
                                                    }
                                                    $output .= '<input name="' . esc_attr( $option_name . '[' . $value['id'] . ']' ) . '" id="' . esc_attr( $value['id'] ) . '" class="of-color"  type="text" value="' . esc_attr( $val ) . '"' . $default_color .' />';
                                    
                                                    break;
                                    
                                                // Uploader
                                                case "upload":
                                                    $output .= Larapress::optionsframework_uploader( $value['id'], $val, null );                                  
                                                    break;
                                    
                                                // Typography
                                                case 'typography':
                                    
                                                    unset( $font_size, $font_style, $font_face, $font_color );
                                    
                                                    $typography_defaults = array(
                                                        'size' => '',
                                                        'face' => '',
                                                        'style' => '',
                                                        'color' => ''
                                                    );
                                    
                                                    $typography_stored = wp_parse_args( $val, $typography_defaults );
                                    
                                                    $typography_options = array(
                                                        'sizes' => of_recognized_font_sizes(),
                                                        'faces' => of_recognized_font_faces(),
                                                        'styles' => of_recognized_font_styles(),
                                                        'color' => true
                                                    );
                                    
                                                    if ( isset( $value['options'] ) ) {
                                                        $typography_options = wp_parse_args( $value['options'], $typography_options );
                                                    }
                                    
                                                    // Font Size
                                                    if ( $typography_options['sizes'] ) {
                                                        $font_size = '<select class="of-typography of-typography-size" name="' . esc_attr( $option_name . '[' . $value['id'] . '][size]' ) . '" id="' . esc_attr( $value['id'] . '_size' ) . '">';
                                                        $sizes = $typography_options['sizes'];
                                                        foreach ( $sizes as $i ) {
                                                            $size = $i . 'px';
                                                            $font_size .= '<option value="' . esc_attr( $size ) . '" ' . selected( $typography_stored['size'], $size, false ) . '>' . esc_html( $size ) . '</option>';
                                                        }
                                                        $font_size .= '</select>';
                                                    }
                                    
                                                    // Font Face
                                                    if ( $typography_options['faces'] ) {
                                                        $font_face = '<select class="of-typography of-typography-face" name="' . esc_attr( $option_name . '[' . $value['id'] . '][face]' ) . '" id="' . esc_attr( $value['id'] . '_face' ) . '">';
                                                        $faces = $typography_options['faces'];
                                                        foreach ( $faces as $key => $face ) {
                                                            $font_face .= '<option value="' . esc_attr( $key ) . '" ' . selected( $typography_stored['face'], $key, false ) . '>' . esc_html( $face ) . '</option>';
                                                        }
                                                        $font_face .= '</select>';
                                                    }
                                    
                                                    // Font Styles
                                                    if ( $typography_options['styles'] ) {
                                                        $font_style = '<select class="of-typography of-typography-style" name="'.$option_name.'['.$value['id'].'][style]" id="'. $value['id'].'_style">';
                                                        $styles = $typography_options['styles'];
                                                        foreach ( $styles as $key => $style ) {
                                                            $font_style .= '<option value="' . esc_attr( $key ) . '" ' . selected( $typography_stored['style'], $key, false ) . '>'. $style .'</option>';
                                                        }
                                                        $font_style .= '</select>';
                                                    }
                                    
                                                    // Font Color
                                                    if ( $typography_options['color'] ) {
                                                        $default_color = '';
                                                        if ( isset($value['std']['color']) ) {
                                                            if ( $val !=  $value['std']['color'] )
                                                                $default_color = ' data-default-color="' .$value['std']['color'] . '" ';
                                                        }
                                                        $font_color = '<input name="' . esc_attr( $option_name . '[' . $value['id'] . '][color]' ) . '" id="' . esc_attr( $value['id'] . '_color' ) . '" class="of-color of-typography-color  type="text" value="' . esc_attr( $typography_stored['color'] ) . '"' . $default_color .' />';
                                                    }
                                    
                                                    // Allow modification/injection of typography fields
                                                    $typography_fields = compact( 'font_size', 'font_face', 'font_style', 'font_color' );
                                                    $typography_fields = apply_filters( 'of_typography_fields', $typography_fields, $typography_stored, $option_name, $value );
                                                    $output .= implode( '', $typography_fields );
                                    
                                                    break;
                                    
                                                // Background
                                                case 'background':
                                    
                                                    $background = $val;
                                    
                                                    // Background Color
                                                    $default_color = '';
                                                    if ( isset( $value['std']['color'] ) ) {
                                                        if ( $val !=  $value['std']['color'] )
                                                            $default_color = ' data-default-color="' .$value['std']['color'] . '" ';
                                                    }
                                                    $output .= '<input name="' . esc_attr( $option_name . '[' . $value['id'] . '][color]' ) . '" id="' . esc_attr( $value['id'] . '_color' ) . '" class="of-color of-background-color"  type="text" value="' . esc_attr( $background['color'] ) . '"' . $default_color .' />';
                                    
                                                    // Background Image
                                                    if ( !isset($background['image']) ) {
                                                        $background['image'] = '';
                                                    }
                                    
                                                    $output .= Options_Framework_Media_Uploader::optionsframework_uploader( $value['id'], $background['image'], null, esc_attr( $option_name . '[' . $value['id'] . '][image]' ) );
                                    
                                                    $class = 'of-background-properties';
                                                    if ( '' == $background['image'] ) {
                                                        $class .= ' hide';
                                                    }
                                                    $output .= '<div class="' . esc_attr( $class ) . '">';
                                    
                                                    // Background Repeat
                                                    $output .= '<select class="of-background of-background-repeat" name="' . esc_attr( $option_name . '[' . $value['id'] . '][repeat]'  ) . '" id="' . esc_attr( $value['id'] . '_repeat' ) . '">';
                                                    $repeats = of_recognized_background_repeat();
                                    
                                                    foreach ($repeats as $key => $repeat) {
                                                        $output .= '<option value="' . esc_attr( $key ) . '" ' . selected( $background['repeat'], $key, false ) . '>'. esc_html( $repeat ) . '</option>';
                                                    }
                                                    $output .= '</select>';
                                    
                                                    // Background Position
                                                    $output .= '<select class="of-background of-background-position" name="' . esc_attr( $option_name . '[' . $value['id'] . '][position]' ) . '" id="' . esc_attr( $value['id'] . '_position' ) . '">';
                                                    $positions = of_recognized_background_position();
                                    
                                                    foreach ($positions as $key=>$position) {
                                                        $output .= '<option value="' . esc_attr( $key ) . '" ' . selected( $background['position'], $key, false ) . '>'. esc_html( $position ) . '</option>';
                                                    }
                                                    $output .= '</select>';
                                    
                                                    // Background Attachment
                                                    $output .= '<select class="of-background of-background-attachment" name="' . esc_attr( $option_name . '[' . $value['id'] . '][attachment]' ) . '" id="' . esc_attr( $value['id'] . '_attachment' ) . '">';
                                                    $attachments = of_recognized_background_attachment();
                                    
                                                    foreach ($attachments as $key => $attachment) {
                                                        $output .= '<option value="' . esc_attr( $key ) . '" ' . selected( $background['attachment'], $key, false ) . '>' . esc_html( $attachment ) . '</option>';
                                                    }
                                                    $output .= '</select>';
                                                    $output .= '</div>';
                                    
                                                    break;
                                    
                                                // Editor
                                                case 'editor':
                                                    $output .= '<div class="explain">' . $explain_value . '</div>'."\n";
                                                    echo $output;
                                                    $textarea_name = esc_attr( $option_name . '[' . $value['id'] . ']' );
                                                    $default_editor_settings = array(
                                                        'textarea_name' => $textarea_name,
                                                        'media_buttons' => false,
                                                        'tinymce' => array( 'plugins' => 'wordpress,wplink' )
                                                    );
                                                    $editor_settings = array();
                                                    if ( isset( $value['settings'] ) ) {
                                                        $editor_settings = $value['settings'];
                                                    }
                                                    $editor_settings = array_merge( $default_editor_settings, $editor_settings );
                                                    wp_editor( $val, $value['id'], $editor_settings );
                                                    $output = '';
                                                    break;
                                    
                                                // Info
                                                case "info":
                                                    $id = '';
                                                    $class = 'section';
                                                    if ( isset( $value['id'] ) ) {
                                                        $id = 'id="' . esc_attr( $value['id'] ) . '" ';
                                                    }
                                                    if ( isset( $value['type'] ) ) {
                                                        $class .= ' section-' . $value['type'];
                                                    }
                                                    if ( isset( $value['class'] ) ) {
                                                        $class .= ' ' . $value['class'];
                                                    }
                                    
                                                    $output .= '<div ' . $id . 'class="' . esc_attr( $class ) . '">' . "\n";
                                                    if ( isset($value['name']) ) {
                                                        $output .= '<h4 class="heading">' . esc_html( $value['name'] ) . '</h4>' . "\n";
                                                    }
                                                    if ( isset( $value['desc'] ) ) {
                                                        $output .= $value['desc'] . "\n";
                                                    }
                                                    $output .= '</div>' . "\n";
                                                    break;
                                    
                                                // Heading for Navigation
                                                case "heading":
                                                    $counter++;
                                                    if ( $counter >= 2 ) {
                                                        $output .= '</div>'."\n";
                                                    }
                                                    $class = '';
                                                    $class = ! empty( $value['id'] ) ? $value['id'] : $value['name'];
                                                    $class = preg_replace('/[^a-zA-Z0-9._\-]/', '', strtolower($class) );
                                                    $output .= '<div id="options-group-' . $counter . '" class="group ' . $class . '">';
                                                    $output .= '<h3>' . esc_html( $value['name'] ) . '</h3>' . "\n";
                                                    break;
                                            }
                                
                                            if ( ( $value['type'] != "heading" ) && ( $value['type'] != "info" ) ) {
                                                $output .= '</div>';
                                                if ( ( $value['type'] != "checkbox" ) && ( $value['type'] != "editor" ) ) {
                                                    $output .= '<div class="explain">' . $explain_value . '</div>'."\n";
                                                }
                                                $output .= '</div></div>'."\n";
                                            }
                                            echo $output;
                                        ?>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </div>
                                    
                                    <div id="optionsframework-submit">
                                        <button type="submit" class="btn btn-primary">Save Options</button>
                                    </div>
                                </form>
                                </div> <!-- / #container -->
                            </div>

                        </div> <!-- / .wrap -->
                    </div>
                    <?php else: ?>
                        <p>No options available...</p>
                    <?php endif; ?>
                </div>
            </div>
        </div>
    </div>


<?php $__env->stopSection(); ?>
<?php $__env->startPush('after-scripts'); ?>
    <script>
        // Loads tabbed sections if they exist
	if ( $('.nav-tab-wrapper').length > 0 ) {
		options_framework_tabs();
	}

	function options_framework_tabs() {

		var $group = $('.group'),
			$navtabs = $('.nav-tab-wrapper a'),
			active_tab = '';

		// Hides all the .group sections to start
		$group.hide();

		// Find if a selected tab is saved in localStorage
		if ( typeof(localStorage) != 'undefined' ) {
			active_tab = localStorage.getItem('active_tab');
		}

		// If active tab is saved and exists, load it's .group
		if ( active_tab != '' && $(active_tab).length ) {
			$(active_tab).fadeIn();
			$(active_tab + '-tab').addClass('nav-tab-active');
		} else {
			$('.group:first').fadeIn();
			$('.nav-tab-wrapper a:first').addClass('nav-tab-active');
		}

		// Bind tabs clicks
		$navtabs.click(function(e) {

			e.preventDefault();

			// Remove active class from all tabs
			$navtabs.removeClass('nav-tab-active');

			$(this).addClass('nav-tab-active').blur();

			if (typeof(localStorage) != 'undefined' ) {
				localStorage.setItem('active_tab', $(this).attr('href') );
			}

			var selected = $(this).attr('href');

			$group.hide();
			$(selected).fadeIn();

		});
	}
    </script>
<?php $__env->stopPush(); ?>

<?php echo $__env->make('admin.layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/asianelearning/public_html/resources/views/admin/themes/options.blade.php ENDPATH**/ ?>