

<?php $__env->startSection('title', trans('labels.backend.page.management')); ?>

<?php $__env->startSection('after-styles'); ?>
        <!-- DataTables -->
  <?php echo e(style('vendor/datatables-bs4/css/dataTables.bootstrap4.min.css')); ?>

  <?php echo e(style('vendor/datatables-responsive/css/responsive.bootstrap4.min.css')); ?>

<?php $__env->stopSection(); ?>

<?php $__env->startSection('page-header'); ?>
        <h1>
            <?php echo e(trans('labels.backend.page.management')); ?>

            <small><?php echo e(trans('labels.backend.page.active')); ?></small>
        </h1>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
    <div class="card">
        <div class="card-header with-border">
            <h3 class="card-title"><?php echo e(trans('labels.backend.page.active')); ?></h3>

            <div class="card-tools float-right">
                <!-- Include your header buttons  -->
                <button type="button" id="delete_button" class="btn btn-xs btn-danger" style="display:none;" onclick="return confirm('Are you sure want to delete this page?');">Delete</button>
                <?php echo e(link_to_route('admin.page.create', trans('menus.backend.page.create'), [], ['class' => 'btn btn-success btn-xs'])); ?>

                <?php echo e(link_to_route('admin.page.deleted', trans('menus.backend.page.deleted'), [], ['class' => 'btn btn-danger btn-xs'])); ?>

            </div><!--card-tools float-right-->
        </div><!-- /.card-header -->

        <div class="card-body">
            <div class="table-responsive">
                <table id="pages-table" class="table table-condensed table-hover">
                    <thead>
                    <tr>
                    <th><input type="checkbox" name="select_all" id="select_all"></th>
                        <th><?php echo e(trans('labels.backend.table.id')); ?></th>
                        <th><?php echo e(trans('labels.backend.table.title')); ?></th>
                        <th>Author</th>
                        <th>Template</th>
                        <th><?php echo e(trans('labels.backend.table.created')); ?></th>
                        <th><?php echo e(trans('labels.backend.table.last_updated')); ?></th>
                        <th><?php echo e(trans('labels.general.actions')); ?></th>
                    </tr>
                    </thead>
                </table>
            </div><!--table-responsive-->
        </div><!-- /.card-body -->
    </div><!--box-->

<?php $__env->stopSection(); ?>
<?php $__env->startPush('after-scripts'); ?>
    <!-- DataTables -->
    <?php echo e(script('vendor/datatables/jquery.dataTables.min.js')); ?>

    <?php echo e(script('vendor/datatables-bs4/js/dataTables.bootstrap4.min.js')); ?>


    <script>
        $(function() {
            var table = $('#pages-table').DataTable({
                processing: true,
                serverSide: true,
                iDisplayLength: 25,
                ajax: {
                    url: '<?php echo e(route("admin.pages.get")); ?>',
                    type: 'post',
                    data: {trashed: false, _token: Laravel.csrfToken}
                },
                columns: [
                    {data: 'select', name: 'select', searchable: false, sortable: false},
                    {data: 'id', name: 'id'},
                    {data: 'title', name: 'title', searchable: false, sortable: false},
                    {data: 'author', name: 'author', searchable: false, sortable: false},
                    {data: 'template', name: 'template'},
                    {data: 'created_at', name: 'created_at'},
                    {data: 'updated_at', name: 'updated_at'},
                    {data: 'actions', name: 'actions', searchable: false, sortable: false}
                ],
                order: [[1, "asc"]],
                searchDelay: 500
            });

             // Handle click on "Select all" control
            $('#select_all').on('click', function(){
                // Get all rows with search applied
                var rows = table.rows({ 'search': 'applied' }).nodes();
                // Check/uncheck checkboxes for all rows in the table
                $('input[type="checkbox"]', rows).prop('checked', this.checked);
                if(!this.checked){
                    $('#delete_button').hide();
                    $('#selected_data div').html('');
                }else{
                    $('#delete_button').show();
                }
            });

            // Handle click on checkbox to set state of "Select all" control
            $('#pages-table tbody').on('change', 'input[type="checkbox"]', function(){
                // If checkbox is not checked
                if(!this.checked){
                    var el = $('#select_all').get(0);
                    // If "Select all" control is checked and has 'indeterminate' property
                    if(el && el.checked && ('indeterminate' in el)){
                        // Set visual state of "Select all" control
                        // as 'indeterminate'
                        el.indeterminate = true;
                    }
                    
                }
                $('#delete_button').show();
            });

            // Handle form submission event
            $('#delete_button').on('click', function(e){          
                $.ajax({
                    url: base_url+'/admin/page/destroy',
                    type: 'get',
                    dataType: 'json',
                    data: table.$('input[type="checkbox"]').serialize(),
                    success: function(data) {
                        table.ajax.reload();
                    }
                });
            });
        });
    </script>
<?php $__env->stopPush(); ?>

<?php echo $__env->make('admin.layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home3/shrestha/ctremit.seshra.com.np/resources/views/admin/pages/index.blade.php ENDPATH**/ ?>