
<?php $__env->startSection('content'); ?>
<div class="title-bar">
    <div class="container text-center">
        <h1><?php echo e($page->title()); ?></h1>
        <div class="breadcrumbs">
            <a href="<?php echo e(url('/')); ?>"><i class="bi bi-house-door-fill"></i> Home</a> / <?php echo e($page->title()); ?>

        </div>
    </div>
</div>

<div class="content-page">
    <div class="container">
        <div class="row">
            <div class="col-lg-8">
                <h3 class="div-title mt-2">Contact Us</h3>
                <h2 class="div-highlight">Have Us Contact Us</h2>
                <?php echo $__env->make('includes.partials.messages', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                <?php echo $page->content(); ?>

                <div class="post-metas">
                    <?php $__currentLoopData = $page->metas()->where('locale', app()->getLocale())->orderBy('post_meta.sort', 'ASC')->get(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $meta): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <div class="row post-meta-block <?php echo e($meta->key); ?>">
                        <?php $__currentLoopData = $meta->pull('post'); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $items): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <div class="col-md-<?php echo e($meta->pull('column', 12)); ?>">
                            <?php $__currentLoopData = $items; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <?php if($item['type'] == 'title_block'): ?>
                                    <div class="post-meta-item title-block">
                                        <h2 style="text-align: <?php echo e($item['align'] ?? ''); ?>;"><?php echo e($item['title'] ?? ''); ?></h2>
                                    </div>
                                <?php elseif($item['type'] == 'title_subtitle_block'): ?>
                                    <div class="post-meta-item title-subtitle-block">
                                        <h2 style="text-align: <?php echo e($item['align'] ?? ''); ?>;"><?php echo e($item['title'] ?? ''); ?></h2>
                                        <h3 style="text-align: <?php echo e($item['align'] ?? ''); ?>;"><?php echo e($item['subtitle'] ?? ''); ?></h3>
                                    </div>
                                <?php elseif($item['type'] == 'text_block'): ?>
                                    <div class="post-meta-item text-block">
                                        <?php echo $item['content']; ?>

                                    </div>
                                <?php elseif($item['type'] == 'text_block_title'): ?>
                                    <div class="post-meta text-block-with-title">
                                        <div class="post-meta-title"><?php echo e($item['title']); ?></div>
                                        <div class="post-meta-body">
                                            <?php echo $item['content']; ?>

                                        </div>
                                    </div>
                                <?php elseif($item['type'] == 'text_block_title_image'): ?>
                                    <div class="row post-meta text-block-title-image">
                                        <div class="col-lg-7">
                                            <div class="post-meta-title"><?php echo e($item['title']); ?></div>
                                            <div class="post-meta-body">
                                                <?php echo $item['content']; ?>

                                            </div>
                                        </div>
                                        <div class="col-lg-5">
                                            <img class="post-meta-image" src="<?php echo e(image($item['featured_image'])); ?>">
                                        </div>
                                    </div>
                                <?php endif; ?>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </div>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </div>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </div>
            </div>

            
            <div class="col-lg-4">
                <h3 class="div-title mt-2">Let's Talk</h3>
                <h2 class="div-highlight">Get in Touch with Us</h2>
                <p class="div-para">Please feel free to contact us. Our team will help to provide you with best solutions</p>

                <div class="row">
                    <div class="col-md-12 mt-2 footer-contacts">
                        <div class="row">
                            <div class="col-md-3 col-2">
                                <div class="footer-icon-div contacts-white">
                                    <i class="bi bi-telephone"></i>
                                </div>
                            </div>

                            <div class="col-md-9 col-10">
                                <h3>Have a Question?</h3>
                                <p>Call Us: <?php echo e(setting('site-phone')); ?>

                                </p>
                            </div>
                        </div>
                    </div>

                    <div class="col-md-12 mt-2 footer-contacts">
                        <div class="row">
                            <div class="col-md-3 col-2">
                                <div class="footer-icon-div contacts-white">
                                    <i class="bi bi-envelope"></i>
                                </div>
                            </div>

                            <div class="col-md-9 col-10">
                                <h3>Write an email</h3>
                                <p><?php echo e(setting('site-email')); ?></p>
                            </div>
                        </div>
                    </div>

                    <div class="col-md-12 mt-2 footer-contacts">
                        <div class="row">
                            <div class="col-md-3 col-2">
                                <div class="footer-icon-div contacts-white">
                                    <i class="bi bi-globe"></i>
                                </div>
                            </div>

                            <div class="col-md-9 col-10">
                                <h3>Visit anytime</h3>
                                <p>arkbotech.com</p>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <div class="container pt-5 mt-5">
        <div class="google-maps">
            <iframe src="https://www.google.com/maps/embed?pb=!1m14!1m8!1m3!1d14132.47031787387!2d85.33486009999913!3d27.68276059999648!3m2!1i1024!2i768!4f13.1!3m3!1m2!1s0x39eb1946de06002b%3A0x19e806e68b1eb1b4!2sARKBO%20Technologies!5e0!3m2!1sen!2snp!4v1708833750017!5m2!1sen!2snp" width="600" height="450" style="border:0;" allowfullscreen="" loading="lazy" referrerpolicy="no-referrer-when-downgrade"></iframe>
        </div>
    </div>
</div>



<?php $__env->stopSection(); ?>
<?php echo $__env->make('gear::layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\laragon\www\arkbo\public\themes/gear/views/contact.blade.php ENDPATH**/ ?>