

<?php $__env->startSection('title', 'Contact Form'); ?>

<?php $__env->startSection('after-styles'); ?>

<?php $__env->stopSection(); ?>

<?php $__env->startSection('page-header'); ?>
    <h1>
        Contact Form
    </h1>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
    <div class="card">
        <div class="card-header with-border">
            <h3 class="card-title">Contact Forms</h3>

            <div class="card-tools float-right">
                <!-- Include your header buttons  -->
                <?php echo e(link_to_route('admin.contact.create','Add Form', [], ['class' => 'btn btn-success btn-xs'])); ?>

            </div><!--box-tools pull-right-->
        </div><!-- /.box-header -->

        <div class="card-body">
            <div class="table-responsive">
                <table id="contact-table" class="table table-condensed table-hover">
                    <thead>
                    <tr>
                        <th><?php echo e(trans('labels.backend.table.id')); ?></th>
                        <th><?php echo e(trans('labels.backend.table.title')); ?></th>
                        <th>Shortcode</th>
                        <th>Receiver Email</th>
                        <th>Status</th>
                        <th>Responses</th>
                        <th><?php echo e(trans('labels.backend.table.created')); ?></th>
                        <th><?php echo e(trans('labels.general.actions')); ?></th>
                    </tr>
                    </thead>
                    <tbody>
                        <?php $__empty_1 = true; $__currentLoopData = $contact_forms; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $contact_form): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                            <tr>
                                <td><?php echo e($contact_form->id); ?></td>
                                <td><?php echo e($contact_form->name); ?></td>
                                <td>
                                    Shortcode: [contact key=<?php echo e($contact_form->slug); ?>] <a href="#" class="clipboard" data-text="[contact key=<?php echo e($contact_form->slug); ?>]">copy</a>
                                </td>
                                <td><?php echo e($contact_form->receiver_email); ?></td>
                                <td><?php echo $contact_form->label('status', 'Active|Deactive'); ?></td>
                                <td><?php echo e($contact_form->responses()->count()); ?></td>
                                <td><?php echo e($contact_form->created_at->diffForHumans()); ?></td>
                                <td><?php echo $contact_form->action_buttons; ?></td>
                            </tr>

                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                        <tr>
                            <td colspan="8" class="text-center">No contacts found...</td>
                        </tr>
                        <?php endif; ?>
                    </tbody>
                </table>
                <?php echo $contact_forms->links(); ?>

            </div><!--table-responsive-->
        </div><!-- /.box-body -->
    </div><!--box-->

<?php $__env->stopSection(); ?>

<?php $__env->startPush('after-scripts'); ?>
 <script>
     $(document).on('click', '.clipboard', function(e) {
        var _this = $(this);
        var text = $(this).data('text');
        navigator.clipboard.writeText(text).then(() => {
            _this.text('copied');
        });
    });
 </script>
<?php $__env->stopPush(); ?>

<?php echo $__env->make('admin.layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/pnccorgn/stage.pncc.org.np/app/Modules/Contact/Resources/Views/index.blade.php ENDPATH**/ ?>