

<?php $__env->startSection('title', trans('labels.backend.menu.create')); ?>

<?php $__env->startSection('page-header'); ?>
    <h1>
        <?php echo e(trans('labels.backend.menu.management')); ?>

        <small><?php echo e(trans('labels.backend.menu.create')); ?></small>
    </h1>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('after-styles'); ?>
    <?php echo style('vendor/nestable/jquery.nestable.css'); ?>

    <style type="text/css">
        .menu-option-button a {
            margin-right: 7px;
        }

        .menuEdit,
        .menuDelete {
            /*display: none;*/
        }

        .dd3-content {
            background: none;
            border-radius: 0px;
        }

        .dd3-handle {
            background: #fff;
            border-radius: 0px;
        }

        .dd3-handle:hover {
            color: #000;
            background: #fff;
        }

        .dd3-handle:before {
            color: #848181;
        }

        .tab-content {
            max-height: 200px;
            min-height: 100px;
            overflow: auto;
            border-left: 1px solid #dddddd;
            border-right: 1px solid #dddddd;
            border-bottom: 1px solid #dddddd;
        }

        #menu_selection {
            padding: 3px;
        }

        #menuForm {
            width: 100%;
        }

        .menu-settings h2 {
            font-size: 20px;
        }

    </style>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
    <div class="col-md-12">
        <div class="row">
            <div class="col-md-3">
                <div class="row gear-menu-edit-area">

                </div>
                <div class="row">
                    <div class="card full-width mb-1" id="card-901">
                        <div class="card-header with-border">
                            <h3 class="card-title"><?php echo e(trans('labels.backend.menu.pages')); ?></h3>

                            <div class="card-tools float-right">
                                <button type="button" class="btn btn-tool" data-card-widget="collapse">
                                    <i class="fas fa-minus"></i>
                                </button>
                            </div>
                            <!--card-tools float-right-->
                        </div><!-- /.card-header -->
                        <div class="card-body">
                            <div class="alert alert-success alert-dismissable" style="display: none">

                            </div>
                            <ul class="nav nav-tabs" id="menuTab" role="tablist">
                                <li class="nav-item">
                                    <a class="nav-link active" id="recent-page-menu-tab" data-toggle="pill"
                                        href="#recent-page-menu" role="tab" aria-controls="recent-page-menu"
                                        aria-selected="true">Most Recent</a>
                                </li>
                                <li class="nav-item">
                                    <a class="nav-link " id="all-page-menu-tab" data-toggle="pill"
                                        href="#all-page-menu" role="tab" aria-controls="all-page-menu"
                                        aria-selected="false">View All</a>
                                </li>
                            </ul>
                            <div class="tab-content" id="page-menu-tab-content">
                                <div class="tab-pane fade active show" id="recent-page-menu" role="tabpanel"
                                    aria-labelledby="recent-page-menu-tab">
                                    <div class="form-group">
                                        <?php $__currentLoopData = $pages->take(3); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $page): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <div class="form-check">
                                                <input class="form-check-input" id="checkbox-page-<?php echo e($page->id); ?>"
                                                    type="checkbox" name="pages[]" value="<?php echo e($page->id); ?>">
                                                <label for="checkbox-page-<?php echo e($page->id); ?>"
                                                    class="form-check-label"><?php echo e($page->title); ?></label>
                                            </div>

                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </div>
                                </div>
                                <div class="tab-pane fade" id="all-page-menu" role="tabpanel"
                                    aria-labelledby="all-page-menu-tab">
                                    <div class="form-group">
                                        <?php $__currentLoopData = $pages; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $page): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <div class="form-check">
                                                <input class="form-check-input" type="checkbox" name="pages[]"
                                                    value="<?php echo e($page->id); ?>">
                                                <label class="form-check-label"><?php echo e($page->title); ?></label>
                                            </div>

                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </div>
                                </div>
                            </div>
                        </div><!-- /.card-body -->
                        <div class="card-footer">
                            <button type="submit" class="btn btn-sm btn-default float-right add_to_menu"
                                id="add_to_menu">Add to Menu</button>
                        </div>
                    </div>
                    <!--card-->
                    <div class="card full-width collapsed-card mb-1" id="card-902">
                        <div class="card-header with-border">
                            <h3 class="card-title"><?php echo e(trans('labels.backend.menu.posts')); ?></h3>

                            <div class="card-tools float-right">
                                <button type="button" class="btn btn-tool" data-card-widget="collapse">
                                    <i class="fas fa-plus"></i>
                                </button>
                            </div>
                            <!--card-tools float-right-->
                        </div><!-- /.card-header -->
                        <div class="card-body">
                            <div class="alert alert-success alert-dismissable" style="display: none">

                            </div>
                            <ul class="nav nav-tabs" id="menuTab" role="tablist">
                                <li class="nav-item">
                                    <a class="nav-link active" id="recent-post-menu-tab" data-toggle="pill"
                                        href="#recent-post-menu" role="tab" aria-controls="recent-post-menu"
                                        aria-selected="true">Most Recent</a>
                                </li>
                                <li class="nav-item">
                                    <a class="nav-link " id="all-post-menu-tab" data-toggle="pill"
                                        href="#all-post-menu" role="tab" aria-controls="all-post-menu"
                                        aria-selected="false">View All</a>
                                </li>
                            </ul>
                            <div class="tab-content" id="post-menu-tab-content">
                                <div class="tab-pane fade active show" id="recent-post-menu" role="tabpanel"
                                    aria-labelledby="recent-post-menu-tab">
                                    <div class="form-group">
                                        <?php $__currentLoopData = $posts->take(3); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $post): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>

                                            <div class="form-check">
                                                <input class="form-check-input" id="checkbox-post-<?php echo e($post->id); ?>"
                                                    type="checkbox" name="pages[]" value="<?php echo e($post->id); ?>">
                                                <label for="checkbox-post-<?php echo e($post->id); ?>"
                                                    class="form-check-label"><?php echo e($post->title); ?></label>
                                            </div>

                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </div>
                                </div>

                                <div class="tab-pane fade" id="all-post-menu" role="tabpanel"
                                    aria-labelledby="all-post-menu-tab">
                                    <div class="form-group">
                                        <?php $__currentLoopData = $posts; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $post): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <div class="form-check">
                                                <input class="form-check-input" type="checkbox" name="pages[]"
                                                    value="<?php echo e($post->id); ?>">
                                                <label class="form-check-label"><?php echo e($post->title); ?></label>
                                            </div>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </div>
                                </div>
                            </div>
                        </div><!-- /.card-body -->
                        <div class="card-footer">
                            <button type="submit" class="btn btn-sm btn-default float-right add_to_menu"
                                id="add_to_menu">Add to Menu</button>
                        </div>
                    </div>
                    <!--card-->
                    <?php echo e(Form::open(['id' => 'menuForm'])); ?>

                    <div class="card mb-1 collapsed-card" id="card-903">
                        <div class="card-header with-border">
                            <h3 class="card-title"><?php echo e(trans('labels.backend.menu.custom_link')); ?></h3>

                            <div class="card-tools float-right">
                                <button type="button" class="btn btn-tool" data-card-widget="collapse">
                                    <i class="fas fa-plus"></i>
                                </button>
                            </div>
                            <!--card-tools float-right-->
                        </div><!-- /.card-header -->

                        <div class="card-body">
                            <div class="alert alert-success alert-dismissable" style="display: none">

                            </div>

                            <div class="form-group">
                                <?php echo e(Form::label('title', trans('validation.attributes.backend.menu.title'))); ?> *
                                <?php echo e(Form::text('title', null, ['class' => 'form-control','placeholder' => trans('validation.attributes.backend.menu.title'),'required'])); ?>

                            </div>
                            <!--form group-->

                            <div class="form-group">
                                <?php echo e(Form::label('url', trans('validation.attributes.backend.menu.url'))); ?>

                                <?php echo e(Form::text('url', null, ['class' => 'form-control','placeholder' => trans('validation.attributes.backend.menu.url')])); ?>

                            </div>
                            <!--form group-->
                            <div class="form-group">
                                <?php echo e(Form::label('icon', trans('validation.attributes.backend.menu.icon'))); ?> (eg. fa-home)
                                <?php echo e(Form::text('icon', null, ['class' => 'form-control','placeholder' => trans('validation.attributes.backend.menu.icon')])); ?>

                            </div>
                            <!--form group-->
                            <div class="form-group">
                                <?php echo e(Form::label('parent', trans('validation.attributes.backend.menu.parent'))); ?>

                                <?php echo e(Form::hidden('parent_id', '0', ['id' => 'parent_id'])); ?>

                                <div class="btn-group dropdown" id="parentMenu">
                                    <button type="button" class="btn btn-default btn-sm dropdown-toggle"
                                        data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
                                        <span id="menuSelected">Select Parent</span> <span class="caret"></span>
                                    </button>
                                    <ul class="dropdown-menu">
                                        <li><a class="dropdown-item" href="0" data-title="None" id="parentLink">None</a>
                                        </li>
                                        <div id="selectMenuList">
                                            <?php echo $__env->make('admin.menus.selectMenuList',['menus' => $menu_groups], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                                        </div>
                                    </ul>
                                </div>
                            </div>
                            <!--form group-->
                        </div><!-- /.card-body -->
                        <div class="card-footer">
                            <div class="float-right">
                                <?php echo e(Form::submit(trans('buttons.backend.menu.add'), ['class' => 'btn btn-default btn-sm'])); ?>

                            </div>
                            <!--float-right-->
                        </div>
                    </div>
                    <!--card-->
                    <?php echo e(Form::close()); ?>

                </div>
            </div>
            <div class="col-md-9">
                <div class="card">
                    <div class="card-header with-border">

                        <div class="card-tools float-left">
                            <?php echo e(Form::label('group', trans('validation.attributes.backend.menu.select'))); ?>

                            <?php echo e(Form::select('menu_id', $groups['menu'], $groups['selected'], ['id' => 'menu_selection'])); ?>

                            <a class="btn btn-success btn-xs group-success" style="display: none"><i
                                    class="fa fa-check"></i></a>

                        </div>
                        <!--card-tools-->
                        <div class="card-tools float-right">
                            <a class="btn btn-default btn-sm" id="AddMenuGroup"><i class="fa fa-plus"
                                    data-toggle="tooltip" data-placement="top" title="Add Menu Group"></i> Add Menu
                                Group</a>
                        </div>

                    </div>
                    <div class="card-body">
                        <p style="font-size: 13px;">Drag each item into the order you prefer.</p>
                        <div class="row">
                        <div class="dd menu-hierarchy">
                            <?php if($menu_groups): ?>
                                <?php echo $__env->make('admin.menus.hierarchy',[
                                'menugroups' => $menu_groups,
                                'menu_id' => $groups['selected']
                                ], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                            <?php else: ?>
                                <p>No menu yet...</p>
                            <?php endif; ?>
                        </div>
                        </div>
                        <div class="row">
                            <div class="menu-settings w-100">
                                <?php echo $__env->make('admin.menus.menuSettings', ['menu_id' => $groups['selected']], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                            </div>
                        </div>
                        
                    </div>
                    
                </div>
            </div>
        </div>
    </div>

    <!-- Menu group modal -->
    <div class="modal menuGroupModal">
        <div class="modal-dialog">
            <div class="modal-content">
                <div class="modal-header">
                    <h4 class="modal-title">Add Menu Group</h4>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">×</span></button>
                </div>
                <?php echo Form::open(['route' => 'admin.menu.group.store']); ?>

                <div class="modal-body">
                    <div class="form-group">
                        <?php echo e(Form::label('title', 'Menu Group Title')); ?>

                        <?php echo e(Form::text('title', null, ['class' => 'form-control','id' => 'group-menu-title','placeholder' => 'Menu Group Title','required'])); ?>

                    </div>
                    <!--form group-->

                    <div class="form-group">
                        <?php echo e(Form::label('mega-menu', 'Mega Menu')); ?>

                        <input type="checkbox" name="mega-menu">
                    </div>
                    <!--form group-->

                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-default float-left" data-dismiss="modal">Close</button>
                    <button type="submit" class="btn btn-primary">Save changes</button>
                </div>
                <?php echo Form::close(); ?>

            </div>
            <!-- /.modal-content -->
        </div>
        <!-- /.modal-dialog -->
    </div>
    <!-- End Menu group model -->


<?php $__env->stopSection(); ?>

<?php $__env->startPush('after-scripts'); ?>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/jquery-cookie/1.4.1/jquery.cookie.min.js"
        integrity="sha512-3j3VU6WC5rPQB4Ld1jnLV7Kd5xr+cq9avvhwqzbH/taCRNURoeEpoPBK9pDyeukwSxwRPJ8fDgvYXd6SkaZ2TA=="
        crossorigin="anonymous"></script>
    <script>
        $(document).ready(function() {

            // Display popup modal of menu group //////////////////////////////////////////
            $(document).on('click', '#AddMenuGroup', function(event) {
                $('.menuGroupModal').modal('show')
            });
            // End ///////////////////////////////////////////////////////////////////////

            // Select Menu Group and Display selected menu ////////////////////////////////
            $('#menu_selection').change(function(event) {
                $('.menu-hierarchy').html('Loading...');
                var menu_id = $('select[name=menu_id]').val()

                $.ajax({
                        url: base_url + '/admin/api/menu/select',
                        type: 'POST',
                        dataType: 'json',
                        data: {
                            menu_id: menu_id,
                            _token: Laravel.csrfToken
                        }
                    })
                    .done(function(data) {
                        $('.menu-hierarchy').html(data.menu);
                        $('.menu-settings').html(data.settings);
                    })
                    .fail(function(data) {

                    });
            });
            // End /////////////////////////////////////////////////////////////////////////

            // Menu Tab Selection /////////////////////////////////////////////////////////////////////////
            $('#menuTab a').on('click', function(e) {
                e.preventDefault();
                $(this).tab('show');
            });

            $('.nav-tabs a').on('shown.bs.tab', function(e) {
                $("input[name='pages[]']").prop('checked', false);
            });

            // Select Menu Option //////////////////////////////////////////////////////////
            $(document).on('click', '#parentMenu #parentLink', function(event) {
                event.preventDefault();
                var id = $(this).attr('href');
                var title = $(this).data('title');
                $('#parent_id').val(id);
                $('#menuSelected').html(title);
            });
            // End /////////////////////////////////////////////////////////////////////////

            // Submit new menu form data ///////////////////////////////////////////////////
            $(document).on('submit', '#menuForm', function(event) {
                event.preventDefault();
                var _data = $(this).serialize();
                $.ajax({
                        url: base_url + '/admin/api/menu/add',
                        type: 'POST',
                        dataType: 'json',
                        data: _data
                    })
                    .done(function(data) {
                        // if(data.toplevel) {

                        // }
                        $('.menu-hierarchy').html(data.menuView);
                        $('#selectMenuList').html(data.menuSelect);
                        $('#menuForm').find("input[type=text], textarea").val("");
                        $('#menuForm .alert').show();
                        $('#menuForm .alert').html('Menu added successfully.');
                        setTimeout(function() {
                            $('#menuForm .alert').fadeOut();
                        }, 5000);
                        //           location.reload();
                        $('input').prop('disabled', false);
                    })
                    .fail(function(data) {
                        console.log(data);
                    });

            });

            $(document).on('click', '.add_to_menu', function(event) {
                event.preventDefault();
                var pageId = []
                var inputs = $(this).parent().parent().find("input[name='pages[]']:checked");
                $(inputs).each(function() {
                    pageId.push(parseInt($(this).val()));
                });
                console.log(pageId);
                if ((pageId.length) > 0) {
                    $.ajax({
                            url: base_url + '/admin/api/menu/add',
                            type: 'POST',
                            dataType: 'json',
                            data: {
                                page_id: pageId,
                                _token: Laravel.csrfToken
                            }
                        })
                        .done(function(data) {
                            $('.menu-hierarchy').html(data.menuView);
                            $('#selectMenuList').html(data.menuSelect);
                            $("input[name='pages[]']").prop('checked', false);
                        })
                        .fail(function(data) {
                            console.log(data);
                        });
                }

            });
            // End /////////////////////////////////////////////////////////////////////////

            $(document).on('click', '#save_location', function(event) {
                event.preventDefault();
                var menuSlug = [];
                var menu_id = $('select[name=menu_id]').val();
                var inputs = $(this).parent().parent().find("input[name='location']:checked");
                $(inputs).each(function() {
                    menuSlug.push(($(this).val()));
                });
                console.log(menuSlug);
                $.ajax({
                        url: base_url + '/admin/api/menu/location',
                        type: 'POST',
                        dataType: 'json',
                        data: {
                            menu_slug: menuSlug,
                            menu_id: menu_id,
                            _token: Laravel.csrfToken
                        }
                    })
                    .done(function(data) {
                        $('.menu-hierarchy').html(data.menuView);
                        $('#selectMenuList').html(data.menuSelect);
                        $("input[name='pages[]']").prop('checked', false);
                    })
                    .fail(function(data) {
                        console.log(data);
                    });

            });

            // Update menu form data ///////////////////////////////////////////////////
            $(document).on('submit', '#menuEditForm', function(event) {
                event.preventDefault();
                var _data = $(this).serialize();
                $.ajax({
                        url: base_url + '/admin/api/menu/update',
                        type: 'POST',
                        dataType: 'json',
                        data: _data
                    })
                    .done(function(data) {

                        $('#menuEditForm .alert').show();
                        $('#menuEditForm .alert').html('Menu updated successfully.');
                        setTimeout(function() {
                            $('#menuEditForm .alert').fadeOut();
                        }, 5000);
                        location.reload();
                    })
                    .fail(function(data) {
                        console.log(data);
                    });

            });
            // End /////////////////////////////////////////////////////////////////////////

            // Delete Menu
            $(document).on('click', '.menuDelete', function(event) {
                event.preventDefault();
                var href = $(this).data('href');

                Swal.fire({
                    title: "Are you sure?",
                    text: "You will not be able to recover this menu!",
                    type: "warning",
                    showCancelButton: true
                }).then((result) => {
                    if (result.value) {
                        $.ajax({
                                url: href,
                                type: 'GET',
                                dataType: 'json',
                            })
                            .done(function(data) {
                                if (data.status) {
                                    LARAPRESS.plugins.notify('success', "<?php echo trans('alerts.backend.menu.deleted'); ?>");
                                    $('.dd-item[data-id="' + data.menu_id + '"]').remove();
                                } else
                                    LARAPRESS.plugins.notify('danger', data.msg);
                            })
                            .fail(function(data) {
                                LARAPRESS.plugins.notify('danger', "<?php echo trans('auth.unknown'); ?>");
                            });
                    }
                });
            });
            // End /////////////////////////////////////////////////////////////////////////

            // Edit Menu Form Display /////////////////////////////////////////////////////
            $(document).on('click', '.menuEdit', function(event) {
                event.preventDefault();
                var url = $(this).data('href');
                $.get(url, function(data) {
                    $('.gear-menu-edit-area').html(data);
                });
            });
            // End ///////////////////////////////////////////////////////////////////////

            $(document).on('change', '.menu-settings input[type=checkbox]', function(event) {
                event.preventDefault();
                var _data = $(this).closest('form').serialize();
                $.ajax({
                        url: base_url + '/admin/api/menu/settings',
                        type: 'POST',
                        dataType: 'json',
                        data:_data
                    })
                    .done(function(data) {
                        LARAPRESS.plugins.notify('success', "Menu settings updated successfully.");
                    })
                    .fail(function(data) {
                        LARAPRESS.plugins.notify('danger', "<?php echo trans('auth.unknown'); ?>");
                    });

            });
            $('.menuEdit').show();
            $('.menuDelete').show();

            $('.card').on('expanded.lte.cardwidget', function(e) {
                var card = $(this).attr('id');
                $.cookie(card, 'expand', {
                    expires: 7,
                    path: '/'
                });
                $('.card').each(function(i, obj) {
                    var card_id = $(this).attr('id');
                    if (card != card_id) $('#' + card_id).CardWidget('collapse');
                });
            });
            $('.card').on('collapsed.lte.cardwidget', function(e) {
                var card = $(this).attr('id');
                $.cookie(card, 'collapse', {
                    expires: 7,
                    path: '/'
                });
            });
            $('.card').each(function(i, obj) {
                var card_id = $(this).attr('id');
                $('#' + card_id).CardWidget($.cookie(card_id));
            });
        });
    </script>

    <?php echo script('vendor/nestable/jquery.nestable.js'); ?>

    <script>
        $(function() {
            var hierarchy = $('.menu-hierarchy');
            hierarchy.nestable({
                maxDepth: 4
            });

            hierarchy.on('change', function() {
                $.ajax({
                    url: "<?php echo e(route('admin.menu.hierarchy')); ?>",
                    type: "post",
                    data: {
                        data: hierarchy.nestable('serialize'),
                        _token: Laravel.csrfToken
                    },
                    success: function(data) {
                        if (data.status)
                            LARAPRESS.plugins.notify('success', "<?php echo trans('strings.backend.menu.hierarchy_saved'); ?>");
                        else
                            LARAPRESS.plugins.notify('danger', "<?php echo trans('auth.unknown'); ?>");
                    },
                    error: function(jqXHR, textStatus, errorThrown) {
                        LARAPRESS.plugins.notify('danger', "<?php echo trans('auth.unknown'); ?>: " + errorThrown);
                    }
                });
            });
        });
    </script>
<?php $__env->stopPush(); ?>

<?php echo $__env->make('admin.layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/pnccorgn/stage.pncc.org.np/resources/views/admin/menus/index.blade.php ENDPATH**/ ?>