

<?php $__env->startSection('title', trans('labels.backend.access.users.management') . ' | ' . trans('labels.backend.access.users.deleted')); ?>

<?php $__env->startSection('after-styles'); ?>
        <!-- DataTables -->
  <?php echo e(style('vendor/datatables-bs4/css/dataTables.bootstrap4.min.css')); ?>

  <?php echo e(style('vendor/datatables-responsive/css/responsive.bootstrap4.min.css')); ?>

<?php $__env->stopSection(); ?>

<?php $__env->startSection('page-header'); ?>
    <h1>
        <?php echo e(trans('labels.backend.access.users.management')); ?>

        <small><?php echo e(trans('labels.backend.access.users.deleted')); ?></small>
    </h1>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
    <div class="card">
        <div class="card-header with-border">
            <h3 class="card-title"><?php echo e(trans('labels.backend.access.users.deleted')); ?></h3>

            <div class="card-tools float-right">
                <?php echo $__env->make('admin.access.includes.partials.user-header-buttons', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
            </div><!--card-tools float-right-->
        </div><!-- /.card-header -->

        <div class="card-body">
            <div class="table-responsive">
                <table id="users-table" class="table table-condensed table-hover">
                    <thead>
                        <tr>
                            <th><?php echo e(trans('labels.backend.access.users.table.id')); ?></th>
                            <th><?php echo e(trans('labels.backend.access.users.table.name')); ?></th>
                            <th><?php echo e(trans('labels.backend.access.users.table.email')); ?></th>
                            <th><?php echo e(trans('labels.backend.access.users.table.confirmed')); ?></th>
                            <th><?php echo e(trans('labels.backend.access.users.table.roles')); ?></th>
                            <th><?php echo e(trans('labels.backend.access.users.table.created')); ?></th>
                            <th><?php echo e(trans('labels.backend.access.users.table.last_updated')); ?></th>
                            <th><?php echo e(trans('labels.general.actions')); ?></th>
                        </tr>
                    </thead>
                </table>
            </div><!--table-responsive-->
        </div><!-- /.card-body -->
    </div><!--box-->
<?php $__env->stopSection(); ?>

<?php $__env->startPush('after-scripts'); ?>
<!-- DataTables -->
    <?php echo e(script('vendor/datatables/jquery.dataTables.min.js')); ?>

    <?php echo e(script('vendor/datatables-bs4/js/dataTables.bootstrap4.min.js')); ?>


	<script>
		$(function() {
            $('#users-table').DataTable({
                processing: true,
                serverSide: true,
                iDisplayLength: 25,
                ajax: {
                    url: '<?php echo e(route("admin.access.user.get")); ?>',
                    type: 'post',
                    data: {status: false, trashed: true, _token: Laravel.csrfToken}
                },
                columns: [
                    {data: 'id', name: '<?php echo e(config('access.users_table')); ?>.id'},
                    {data: 'profile.firstname', name: 'profile.firstname', render: $.fn.dataTable.render.text()},
                    {data: 'email', name: '<?php echo e(config('access.users_table')); ?>.email', render: $.fn.dataTable.render.text()},
                    {data: 'confirmed', name: '<?php echo e(config('access.users_table')); ?>.confirmed'},
                    {data: 'roles', name: '<?php echo e(config('access.roles_table')); ?>.name', sortable: false},
                    {data: 'created_at', name: '<?php echo e(config('access.users_table')); ?>.created_at'},
                    {data: 'updated_at', name: '<?php echo e(config('access.users_table')); ?>.updated_at'},
                    {data: 'actions', name: 'actions', searchable: false, sortable: false}
                ],
                order: [[0, "asc"]],
                searchDelay: 500
            });

            $("body").on("click", "a[name='delete_user_perm']", function(e) {
                e.preventDefault();
                var linkURL = $(this).attr("href");

                Swal.fire({
                    title: "<?php echo e(trans('strings.backend.general.are_you_sure')); ?>",
                    text: "<?php echo e(trans('strings.backend.access.users.delete_user_confirm')); ?>",
                    icon: "warning",
                    showCancelButton: true,
                    confirmButtonColor: "#DD6B55",
                    confirmButtonText: "<?php echo e(trans('strings.backend.general.continue')); ?>",
                    cancelButtonText: "<?php echo e(trans('buttons.general.cancel')); ?>",
                }).then((result) => {
                    result.value && window.location.assign(linkURL);
                });
            });

            $("body").on("click", "a[name='restore_user']", function(e) {
                e.preventDefault();
                var linkURL = $(this).attr("href");

                Swal.fire({
                    title: "<?php echo e(trans('strings.backend.general.are_you_sure')); ?>",
                    text: "<?php echo e(trans('strings.backend.access.users.restore_user_confirm')); ?>",
                    icon: "warning",
                    showCancelButton: true,
                    confirmButtonColor: "#DD6B55",
                    confirmButtonText: "<?php echo e(trans('strings.backend.general.continue')); ?>",
                    cancelButtonText: "<?php echo e(trans('buttons.general.cancel')); ?>",
                }).then((result) => {
                    result.value && window.location.assign(linkURL);
                });
            });
		});
	</script>
<?php $__env->stopPush(); ?>

<?php echo $__env->make('admin.layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/ritubeau/public_html/resources/views/admin/access/deleted.blade.php ENDPATH**/ ?>