

<?php $__env->startSection('title', trans('labels.backend.category.create')); ?>

<?php $__env->startSection('page-header'); ?>
    <h1>
        <?php echo e(trans('labels.backend.category.management')); ?>

        <small><?php echo e(trans('labels.backend.category.create')); ?></small>
    </h1>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('after-styles'); ?>
<style>
</style>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
<div class="col-md-12">
    <div class="row">
        <div class="col-md-4">
            <div class="alert alert-success alert-dismissable" style="display: none">
            </div>
            <div id="editCategoryForm">

            </div>
            <div id="addCategoryForm">
                <?php echo e(Form::open(['route' => 'admin.category.create', 'role' => 'form', 'method' => 'post'])); ?>


                    <div class="card">
                        <div class="card-header with-border">
                            <h3 class="card-title"><?php echo e(trans('labels.backend.category.create')); ?></h3>

                            <div class="card-tools float-right">
                                <!-- Include your header buttons -->
                            </div><!--card-tools float-right-->
                        </div><!-- /.card-header -->

                        <div class="card-body">
                            <div class="form-group">
                                <?php echo e(Form::label('title', 'Title')); ?>

                                <?php echo e(Form::text('title', null, ['class' => 'form-control', 'placeholder' => 'Title'])); ?>

                            </div><!--form control-->

                            <div class="form-group">
                                <?php echo e(Form::label('slug', trans('validation.attributes.backend.category.slug'))); ?>

                                <?php echo e(Form::text('slug', null, ['class' => 'form-control', 'placeholder' => trans('validation.attributes.backend.category.slug')])); ?>

                            </div><!--form control-->

                            <div class="form-group">
                                <?php echo e(Form::label('description', trans('validation.attributes.backend.category.description'))); ?>

                                <?php echo e(Form::textarea('description', null, ['size' => '30x5', 'class' => 'form-control', 'placeholder' => trans('validation.attributes.backend.category.description')])); ?>

                            </div><!--form control-->
                            <div class="form-group">
                                <?php echo e(Form::label('parent', trans('validation.attributes.backend.category.parent'))); ?>

                                <?php echo e(Form::hidden('parent_id','0',['id' => 'parent_id'])); ?>

                                <div class="btn-group dropup" id="parentCategory">
                                <button type="button" class="btn btn-danger dropdown-toggle" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
                                    <span id="categorySelected">Select Parent</span> <span class="caret"></span>
                                </button>
                                <ul class="dropdown-menu">
                                    <li>
                                        <a class="dropdown-item" href="0" data-title="None" id="parentLink">None</a>
                                    </li>
                                    <?php echo $__env->make('admin.category.hierarchy',['categories' => $categories], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                                </ul>
                                </div>
                            </div><!--form control-->
                 
                            <div class="form-group">
                                <label>Featured Image</label>
                                <div class="input-group" data-toggle="seshra-uploader" data-type="image" data-group="category">
                                    <div class="input-group-prepend">
                                        <div class="input-group-text bg-soft-secondary font-weight-medium">Browse</div>
                                    </div>
                                    <div class="form-control file-amount">Choose File</div>
                                    <input type="hidden" name="media_id" class="selected-files">
                                </div>
                                <div class="file-preview box sm">
                                </div>
                            </div>
                        </div><!-- /.box-body -->
                    </div><!--box-->

                    <div class="card">
                        <div class="card-body">
                            <div class="float-left">
                                <?php echo e(link_to_route('admin.category.create', trans('buttons.general.cancel'), [], ['class' => 'btn btn-danger btn-xs'])); ?>

                            </div><!--float-left-->

                            <div class="float-right">
                                <?php echo e(Form::submit(trans('buttons.general.crud.create'), ['class' => 'btn btn-success btn-xs'])); ?>

                            </div><!--float-right-->

                            <div class="clearfix"></div>
                        </div><!-- /.card-body -->
                    </div><!--box-->

                <?php echo e(Form::close()); ?>

            </div>
        </div>
        <div class="col-md-8">
            <div class="card">
                <div class="card-header with-border">
                    <h3 class="card-title"><?php echo e(trans('labels.backend.category.all')); ?></h3>

                    <div class="card-tools float-right">
                        <button type="button" id="delete_button" class="btn btn-xs btn-danger d-none" onclick="return confirm('Are you sure want to delete this categories?');">Delete</button>
                    </div><!--card-tools float-right-->
                </div><!-- /.card-header -->

                <div class="card-body">
                    <div class="table-responsive">
                    <table class="table table-hover categorytable">
                        <tbody>
                            <tr>
                            <th><input type="checkbox" name="select_all" id="select_all"></th>
                            <th>Categories</th>
                            <th>Slug</th>
                            <th>Status</th>
                            <th>Count</th>
                            <th>Actions</th>
                            </tr>
                            <?php echo $__env->make('admin.category.list', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>                            
                        </tbody>
                    </table>
                </div>
                <?php echo e($parents->links()); ?>

                </div><!-- /.card-body -->
            </div><!--box-->
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('after-scripts'); ?>
   <script>
    $(document).ready(function(){
        $('#parentCategory #parentLink').click(function(event) {
            event.preventDefault();
            var id = $(this).attr('href');
            var title = $(this).data('title');
            $('#parent_id').val(id);
            $('#categorySelected').html(title);
        });

        $(document).on('click', '#select_all', function() {
            var table = $(this).closest('table');  
            if (this.checked) {
                $('#delete_button').removeClass('d-none');
                table.find("input:checkbox[name='id[]']").prop("checked", true);
            } else {
                $('#delete_button').addClass('d-none');
                table.find("input:checkbox[name='id[]']").prop("checked", false);
            }
        });

        // Handle click on checkbox to set state of "Select all" control
        $('.categorytable tbody').on('change', 'input[type="checkbox"]', function() {
                // If checkbox is not checked
                var table = $(this).closest('table');
                if(!this.checked){
                    var el = $('#select_all').get(0);
                    if(el && el.checked && ('indeterminate' in el)){
                        el.indeterminate = true;
                    }
                    var uncheckedInput = table.find("input:checkbox[name='id[]']:checked").length;
                    if(uncheckedInput == 0){
                        el.indeterminate = false;
                        $('#select_all').prop('checked', false);
                        $('#delete_button').addClass('d-none');
                    }
                    
                }
                else {
                    $('#delete_button').removeClass('d-none');
                }
            });

        // Handle form submission event
        $('#delete_button').on('click', function(e) {
            var table = $('table');
            var data = table.find('input[type="checkbox"]').serialize();
            data = data+'&_token='+Laravel.csrfToken;
                $.ajax({
                    url: base_url+'/admin/category/deleteSelected',
                    type: 'post',
                    dataType: 'json',
                    data: data,
                    success: function(data) {
                        window.location.reload();
                    }
                });
            });

       

        // Edit Category Form Display /////////////////////////////////////////////////////
        $('.editCategory').click(function(event) {
            event.preventDefault();
            var url = $(this).attr('href');
            $.get(url, function(data) {
                $('#addCategoryForm').hide();
                $('#editCategoryForm').html(data);
            })
            .done(function() {
                console.log( "second success" );
            })
            .fail(function() {
                alert( "error" );
            })
            .always(function() {
                console.log( "finished" );
            });
        });
        // End ///////////////////////////////////////////////////////////////////////
        
    // Submit new menu form data ///////////////////////////////////////////////////
    $(document).on('submit', '#categoryForm', function(event) {
        event.preventDefault();
        var _data = $(this).serialize();
        $.ajax({
            url: base_url + '/admin/category/update',
            type: 'POST',
            dataType: 'json',
            data: _data
        })
        .done(function(data) {
            $('#categoryForm').find("input[type=text], textarea").val("");
            $('#categoryForm .alert').show();
            $('#categoryForm .alert').html('Category updated successfully.');
            setTimeout(function() {
                $('#categoryForm .alert').fadeOut();
            }, 5000);
            location.reload();
        })
        .fail(function(data) {
            console.log(data);
        });
    });
    // End /////////////////////////////////////////////////////////////////////////
    
    });
   </script>
<?php $__env->stopPush(); ?>

<?php echo $__env->make('admin.layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/ritubeau/public_html/resources/views/admin/category/create.blade.php ENDPATH**/ ?>