

<?php $__env->startSection('title', trans('labels.backend.theme.editor')); ?>

<?php $__env->startSection('after-styles'); ?>
    <link rel="stylesheet" href="<?php echo e(public_asset('vendor/codemirror/codemirror.css')); ?>">
    <link rel="stylesheet" href="<?php echo e(public_asset('vendor/codemirror/theme/monokai.css')); ?>">
    <style type="text/css">
        .theme-editor .CodeMirror, .theme-editor textarea {
            width: 100%;
            height: 700px;
        }

        .theme-editor ul {
            list-style: none;
            margin: 0;
            padding: 0;
        }

        .theme-editor ul li:hover {
            background-color: rgb(224, 224, 224);
        }

        .theme-editor .filename {
            display: block;
            margin: 0;
            padding: 5px 8px 0 8px;
            font-weight: 600;
            text-decoration: none;
        }

        .theme-editor .file-subname {
            color: #666;
            font-size: 12px;
            font-style: italic;
            padding-left: 15px;
        }
        .theme-file-list {
            height: 700px;
            overflow-y: scroll;
        }

        .theme-file-list li.active{
            background-color: rgb(224, 224, 224);
        }
        .theme-file-list .nav-sidebar li{
            border: 0!important;
        }

        .theme-file-list .has-treeview>a{
            font-size: 16px;
            font-weight: 700;
        }
        .theme-file-list .nav-sidebar .menu-open > .nav-link i.fa-angle-left{
            transform: rotate(-90deg);
        }
        .theme-file-list .nav-link{
            padding: 0.25rem 0;
        }
    </style>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
    <div class="theme-editor">
        <?php echo Form::open(['route' => 'admin.theme.editor', 'class' => 'form-horizontal codeForm']); ?>

        <input type="hidden" name="file" value="<?php echo e(Request::get('file')); ?>">
        <div class="row">
            <div class="col-lg-10 col-sm-8">
                <div class="card">
                    <div class="card-header with-border">
                        <h3 class="card-title">Theme Editor</h3>
                    </div>
                    <div class="card-body">
                        <textarea name="code" class="texteditor" id="code"><?php echo $contents; ?></textarea>
                    </div>
                    <!-- /.card-body -->
                </div>
                <div class="card">
                    <div class="card-body">

                        <div class="float-right">
                            <?php echo e(Form::submit(trans('buttons.general.crud.update'), ['class' => 'btn btn-primary btn-md'])); ?>

                        </div>
                    </div><!-- /.card-body -->
                </div>
            </div>
            <div class="col-lg-2 col-sm-4">
                <div class="card">
                    <div class="card-header with-border">
                        <h3 class="card-title">Theme Files</h3>
                    </div>
                    <!-- /.card-header -->
                    <div class="card-body">
                        <div class="form-group col-md-12 theme-file-list">
                            <ul class="nav nav-pills nav-sidebar flex-column" data-widget="treeview" role="menu" data-accordion="false"  data-toggle="larapress-menu">
                                <?php $__currentLoopData = $theme_files; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $theme_file): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                  <?php if(isset($theme_file['children'])): ?>
                                    <li class="larapress-nav-item has-treeview nav-item">
                                      <a href="#" class="nav-link"> <i class="fas fa-folder"></i> <?php echo e($theme_file['directory']); ?> <i class="fas fa-angle-left"></i></a>
                                      <ul class="nav nav-treeview ">
                                        <?php $__currentLoopData = $theme_file['children']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $children): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                          <li class="<?php echo e(Request::get('file') == $children['filename'] ? 'active' : ''); ?>">
                                            <a href="<?php echo e(route('admin.theme.editor', ['file' => $children['filename']])); ?>" class="file-list">
                                                <span class="filename"><?php echo e($children['name']); ?></span>
                                                <span class="file-subname">( <?php echo e($children['filename']); ?> )</span>
                                            </a>
                                          </li>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                      </ul>
                                    </li>
                                   
                                  <?php else: ?>
                                  <li class="<?php echo e(Request::get('file') == $theme_file['filename'] ? 'active' : ''); ?>">
                                      <a href="<?php echo e(route('admin.theme.editor', ['file' => $theme_file['filename']])); ?>" class="file-list nav-link">
                                          <span class="filename"><?php echo e($theme_file['name']); ?></span>
                                          <span class="file-subname">( <?php echo e($theme_file['filename']); ?> )</span>
                                      </a>
                                  </li>
                                  <?php endif; ?>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </ul>
                        </div>
                    </div>
                    <!-- /.card-body -->
                </div>
            </div>
        </div>
        
        <?php echo e(Form::close()); ?>

    </div>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('after-scripts'); ?>
    <script src="<?php echo e(public_asset('vendor/codemirror/codemirror.js')); ?>"></script>
    <script src="<?php echo e(public_asset('vendor/codemirror/addon/edit/matchbrackets.js')); ?>"></script>
    <script src="<?php echo e(public_asset('vendor/codemirror/mode/htmlmixed/htmlmixed.js')); ?>"></script>
    <script src="<?php echo e(public_asset('vendor/codemirror/mode/xml/xml.js')); ?>"></script>
    <script src="<?php echo e(public_asset('vendor/codemirror/mode/javascript/javascript.js')); ?>"></script>
    <script src="<?php echo e(public_asset('vendor/codemirror/mode/css/css.js')); ?>"></script>
    <script src="<?php echo e(public_asset('vendor/codemirror/mode/clike/clike.js')); ?>"></script>
    
    <script>
      var filename = "<?php echo e(Request::get('file')); ?>";
    //   var mode = "application/x-httpd-php";
      var mode = "htmlmixed";
      if(filename.includes('json') || filename.includes('js')) {
        mode ="javascript"
      } else if(filename.includes('css')) {
        mode ="css";
      } else if(!filename.includes('blade.php') && filename.includes('php')) {
        mode ="javascript"
      }
      var editor = CodeMirror.fromTextArea(document.getElementById("code"), {
        lineNumbers: true,
        matchBrackets: true,
        mode: mode,
        indentUnit: 4,
        indentWithTabs: true,
        theme: "monokai"
      });

      $(document).on('submit', '.codeForm', function(e) {
        e.preventDefault();
        loading();
        _this = $(this);

        $.ajax({
            type: "POST",
            url: "<?php echo e(route("admin.theme.editor")); ?>",
            data: _this.serialize(),
            success: function(data) {
               if(data.status) {
                LARAPRESS.plugins.notify('success', data.message);
               }else {
                LARAPRESS.plugins.notify('danger', data.message);
               }
            },
            error: function() {
                LARAPRESS.plugins.notify('danger', 'Something went wrong');
            },
            complete: function() {
                _this.find('input[type="submit"]').attr('disabled', false);
                loading(false);
            }
        });
      });

    $(document).keydown(function(event) {
        if ((event.which === 83 && event.ctrlKey)) {
            event.preventDefault();
            $(".codeForm input[type=submit]").click();
            
        };
    });
      
    
    </script>
<?php $__env->stopPush(); ?>

<?php echo $__env->make('admin.layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\laragon\www\arkbo\resources\views/admin/themes/editor.blade.php ENDPATH**/ ?>