

<?php $__env->startSection('title', trans('labels.backend.access.users.management') . ' | ' . trans('labels.backend.access.users.edit')); ?>

<?php $__env->startSection('page-header'); ?>
    <h1>
        <?php echo e(trans('labels.backend.access.users.management')); ?>

        <small><?php echo e(trans('labels.backend.access.users.edit')); ?></small>
    </h1>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
    <?php echo e(Form::model($user, ['route' => ['admin.access.user.update', $user], 'class' => 'form-horizontal', 'role' => 'form', 'method' => 'PATCH'])); ?>


        <div class="card">
            <div class="card-header with-border">
                <h3 class="card-title"><?php echo e(trans('labels.backend.access.users.edit')); ?></h3>

                <div class="card-tools float-right">
                    <?php echo $__env->make('admin.access.includes.partials.user-header-buttons', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                </div><!--card-tools float-right-->
            </div><!-- /.card-header -->

            <div class="card-body">
                <div class="form-group">
                    <?php echo e(Form::label('name', trans('validation.attributes.backend.access.users.name'), ['class' => 'col-lg-2 control-label'])); ?>


                    <div class="col-lg-10">
                        <?php echo e(Form::text('name', null, ['class' => 'form-control', 'placeholder' => trans('validation.attributes.backend.access.users.name')])); ?>

                    </div><!--col-lg-10-->
                </div><!--form control-->

                <div class="form-group">
                    <?php echo e(Form::label('email', trans('validation.attributes.backend.access.users.email'), ['class' => 'col-lg-2 control-label'])); ?>


                    <div class="col-lg-10">
                        <?php echo e(Form::text('email', null, ['class' => 'form-control', 'placeholder' => trans('validation.attributes.backend.access.users.email')])); ?>

                    </div><!--col-lg-10-->
                </div><!--form control-->

                <?php if($user->id != 1): ?>
                    <div class="form-group">
                        <?php echo e(Form::label('status', trans('validation.attributes.backend.access.users.active'), ['class' => 'col-lg-2 control-label'])); ?>


                        <div class="col-lg-1">
                            <?php echo e(Form::checkbox('status', '1', $user->status == 1)); ?>

                        </div><!--col-lg-1-->
                    </div><!--form control-->

                    <div class="form-group">
                        <?php echo e(Form::label('confirmed', trans('validation.attributes.backend.access.users.confirmed'), ['class' => 'col-lg-2 control-label'])); ?>


                        <div class="col-lg-1">
                            <?php echo e(Form::checkbox('confirmed', '1', $user->confirmed == 1)); ?>

                        </div><!--col-lg-1-->
                    </div><!--form control-->

                    <div class="form-group">
                        <?php echo e(Form::label('status', trans('validation.attributes.backend.access.users.associated_roles'), ['class' => 'col-lg-2 control-label'])); ?>


                        <div class="col-lg-3">
                            <?php if(count($roles) > 0): ?>
                                <?php $__currentLoopData = $roles; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $role): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <input type="checkbox" value="<?php echo e($role->id); ?>" name="assignees_roles[<?php echo e($role->id); ?>]" <?php echo e(in_array($role->id, $userRoles) ? 'checked' : ''); ?> id="role-<?php echo e($role->id); ?>" /> <label for="role-<?php echo e($role->id); ?>"><?php echo e($role->name); ?></label>
                                        <a href="#" data-role="role_<?php echo e($role->id); ?>" class="show-permissions small">
                                            (
                                                <span class="show-text"><?php echo e(trans('labels.general.show')); ?></span>
                                                <span class="hide-text hidden"><?php echo e(trans('labels.general.hide')); ?></span>
                                                <?php echo e(trans('labels.backend.access.users.permissions')); ?>

                                            )
                                        </a>
                                    <br/>
                                    <div class="permission-list hidden" data-role="role_<?php echo e($role->id); ?>">
                                        <?php if($role->all): ?>
                                            <?php echo e(trans('labels.backend.access.users.all_permissions')); ?><br/><br/>
                                        <?php else: ?>
                                            <?php if(count($role->permissions) > 0): ?>
                                                <blockquote class="small"><?php $__currentLoopData = $role->permissions; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $perm): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?><?php echo e($perm->display_name); ?><br/>
                                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                </blockquote>
                                            <?php else: ?>
                                                <?php echo e(trans('labels.backend.access.users.no_permissions')); ?><br/><br/>
                                            <?php endif; ?>
                                        <?php endif; ?>
                                    </div><!--permission list-->
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            <?php else: ?>
                                <?php echo e(trans('labels.backend.access.users.no_roles')); ?>

                            <?php endif; ?>
                        </div><!--col-lg-3-->
                    </div><!--form control-->
                <?php endif; ?>
            </div><!-- /.card-body -->
        </div><!--box-->

        <div class="card">
            <div class="card-body">
                <div class="float-left">
                    <?php echo e(link_to_route('admin.access.user.index', trans('buttons.general.cancel'), [], ['class' => 'btn btn-danger btn-xs'])); ?>

                </div><!--float-left-->

                <div class="float-right">
                    <?php echo e(Form::submit(trans('buttons.general.crud.update'), ['class' => 'btn btn-success btn-xs'])); ?>

                </div><!--float-right-->

                <div class="clearfix"></div>
            </div><!-- /.card-body -->
        </div><!--box-->

        <?php if($user->id == 1): ?>
            <?php echo e(Form::hidden('status', 1)); ?>

            <?php echo e(Form::hidden('confirmed', 1)); ?>

            <?php echo e(Form::hidden('assignees_roles[]', 1)); ?>

        <?php endif; ?>

    <?php echo e(Form::close()); ?>

<?php $__env->stopSection(); ?>

<?php $__env->startPush('after-scripts'); ?>
    <?php echo e(script('js/backend/access/users/script.js')); ?>

<?php $__env->stopPush(); ?>

<?php echo $__env->make('admin.layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/ritubeau/public_html/resources/views/admin/access/edit.blade.php ENDPATH**/ ?>