

<?php $__env->startSection('title', trans('labels.backend.page.edit')); ?>

<?php $__env->startSection('page-header'); ?>
    <h1>
        <?php echo e(trans('labels.backend.page.management')); ?>

        <small><?php echo e(trans('labels.backend.page.edit')); ?></small>
    </h1>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('after-styles'); ?>

<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
    <?php echo e(Form::model($page, ['route' => ['admin.page.update', $page->id], 'role' => 'form', 'method' => 'put'])); ?>

    <input name="lang" type="hidden" value="<?php echo e($lang); ?>">
    <div class="row">
        <div class="col-md-8">
            <ul class="nav nav-tabs nav-fill border-light">
                <?php $__currentLoopData = locales(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $locale): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
  					<li class="nav-item">
  						<a class="nav-link text-reset <?php if($locale == $lang ): ?> active <?php else: ?> bg-soft-dark border-light border-left-0 <?php endif; ?> py-3" href="<?php echo e(route('admin.page.edit', $page->id)); ?>?lang=<?php echo e($locale); ?>">
  							<img src="<?php echo e(public_asset('images/flags/'.$locale.'.png')); ?>" height="11" class="mr-1">
  							<span><?php echo e($locale); ?></span>
  						</a>
  					</li>
  		        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </ul>
            <div class="card">
                <div class="card-header with-border">
                    <h3 class="card-title"><?php echo e(trans('labels.backend.page.edit')); ?></h3>

                    <div class="card-tools float-right">
                        <?php echo e(link_to_route('admin.page.create', trans('menus.backend.page.create'), [], ['class' => 'btn btn-success btn-xs'])); ?>

                        <a href="<?php echo e(route('post', $page->slug)); ?>"  class="btn btn-primary btn-xs" target="_blank"><?php echo e(trans('menus.backend.page.view')); ?></a>
                    </div>
                </div>

                <div class="card-body">
                    
                    <div class="form-group">
                        <?php echo e(Form::label('title', trans('validation.attributes.backend.page.title'))); ?>

                        <input type="text" class="form-control" name="<?php echo e($lang); ?>[title]" value="<?php echo e($page->translate($lang)->title ?? $page->title); ?>" placeholder="<?php echo e(trans('validation.attributes.backend.page.title')); ?>">
                    </div>
                    <div class="form-group">
                        <?php echo e(Form::label('subtitle', trans('validation.attributes.backend.page.subtitle'))); ?>

                        <textarea name="<?php echo e($lang); ?>[subtitle]" class="form-control seshra-text-editor" data-airmode="true" placeholder="<?php echo e(trans('validation.attributes.backend.page.subtitle')); ?>"><?php echo $page->translate($lang)->subtitle ?? $page->subtitle; ?></textarea>
                    </div>
                    <div class="form-group">
                        <?php echo e(Form::label('slug', trans('validation.attributes.backend.page.slug'))); ?>

                        <?php echo e(Form::text('slug', null, ['class' => 'form-control','placeholder' => trans('validation.attributes.backend.page.slug')])); ?>

                    </div>
                    <div class="form-group">
                        <label for="content">Content</label>
                        <textarea name="<?php echo e($lang); ?>[content]" class="seshra-text-editor" data-min-height="300" data-image-submit-url="<?php echo e(route('admin.image.upload')); ?>" data-format="true" data-image-group="blogs"><?php echo $page->translate($lang)->content ?? $page->content; ?></textarea>
                    </div>

                    <div class="form-group">
                        <label for="meta-title" class="meta-title">Meta Title <small>(Recommended less than 60
                                characters) <span id="meta_title_length"
                                    class="<?php echo e(strlen($page->meta_title) < 61 ? 'green' : 'red'); ?>"><?php echo e(strlen($page->meta_title)); ?>

                                    characters</span></small></label>
                        <?php echo e(Form::text('meta_title', null, ['class' => 'form-control','placeholder' => 'Meta Title','id' => 'meta-title'])); ?>

                    </div>

                    <div class="form-group">
                        <label for="meta-description" class="meta-description">Meta Description <small>(Recommended less
                                than 160 characters) <span id="meta_description_length"
                                    class="<?php echo e(strlen($page->meta_description) < 161 ? 'green' : 'red'); ?>"><?php echo e(strlen($page->meta_description)); ?>

                                    characters</span></small></label>
                        <?php echo e(Form::textarea('meta_description', null, ['class' => 'form-control','rows' => '4','id' => 'meta-description'])); ?>

                    </div>
                </div>
            </div>
            <div id="dynamic-block-container">
                <?php $__currentLoopData = $page->metas()->where('locale', $lang)->orderBy('post_meta.sort', 'ASC')->get(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $meta): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <?php
                        $items['metaitem'] = json_decode($meta->value, true);
                        $items['name'] = $meta->key;
                        $cols = count($items['metaitem']) > 0 ? count($items['metaitem']) : 1;
                        $items['column'] = 12/$cols;
                        $block = explode('-', $meta->key);
                        $items['block'] = $block[1] ?? $loop->iteration;
                    ?>
                    <?php echo $__env->make('admin.dynamic_block.block', $items, \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </div>
            <?php if(default_lang() == $lang): ?>
            <div class="row mb-5">
                <div class="col-md-12">
                    <div class="btn-group dropup float-right" id="dynamic-text-block">
                        <button type="button" class="btn btn-primary" data-toggle="modal" data-target="#dynamic-block-modal">
                            Add Block
                        </button>
                    </div>
                </div>
            </div>
            <?php endif; ?>
        </div>
        <div class="col-md-4">
            <div class="card">
                <div class="card-header with-border">
                    <h3 class="card-title">Page Template</h3>
                </div><!-- /.card-header -->

                <div class="card-body">
                    <div class="form-group">
                        <select name="template" class="form-control">
                            <option value="default" <?php echo e($page->type == 'default' ? 'selected' : ''); ?>>Default</option>
                            <?php if($templates != null): ?>
                                <?php $__currentLoopData = $templates; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $template_slug => $template): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <option value="<?php echo e($template_slug); ?>"  <?php echo e($page->template == $template_slug ? 'selected' : ''); ?>><?php echo e($template); ?></option>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            <?php endif; ?>
                        </select>

                    </div>
                    <!--form group-->
                </div>
            </div>
            <div class="card">
                <div class="card-header with-border">
                    <h3 class="card-title">Featured</h3>
                </div><!-- /.card-header -->
                <div class="card-body">
                    <div class="form-group">
                        <div class="input-group" data-toggle="seshra-uploader" data-type="image" data-group="blogs">
                            <div class="input-group-prepend">
                                <div class="input-group-text bg-soft-secondary font-weight-medium">Browse</div>
                            </div>
                            <div class="form-control file-amount">Choose File</div>
                            <input type="hidden" name="media_id" value="<?php echo e($page->media_id); ?>" class="selected-files">
                        </div>
                        <div class="file-preview box sm">
                        </div>
                    </div>
                </div><!-- /.card-body -->
            </div>
            <!--card-->
            <div class="card position-sticky" style="top: 30px">
                <div class="card-body">
                    <div class="form-group">
                        <?php echo e(Form::submit(trans('buttons.general.crud.update'), ['class' => 'btn btn-success btn-md'])); ?>

                    </div>
                </div>
                <!--form control-->
            </div>
            <!--card-->
        </div>
    </div>
    <?php echo e(Form::close()); ?>

    
    <div class="modal fade" id="dynamic-block-modal" tabindex="-1" role="dialog" aria-labelledby="dynamic-block-label"
    aria-hidden="true">
    <div class="modal-dialog" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="exampleModalLabel">Add Block</h5>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>
                <div class="modal-body">
                    <div class="form-group">
                        <label>Column</label>
                        <select class="form-control" name="cols" id="block_cols">
                            <option value="1">1</option>
                            <option value="2">2</option>
                            <option value="3">3</option>
                            <option value="4">4</option>
                        </select>
                        <?php
                            $count = 1;
                            $block = $page->metas()->orderBy('post_meta.id', 'DESC')->first();
                            if($block) {
                                $key = explode('-',$block->key);
                                $count = $key[1] ?? 1;
                            }
                        ?>
                        <input type="hidden" id="block_count" value="<?php echo e($count); ?>">
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-dismiss="modal">Close</button>
                    <button type="button" class="btn btn-primary" id="add-block">Add</button>
                </div>
            
        </div>
    </div>
</div>
    

    
    <div class="modal fade" id="edit-dynamic-block-modal" tabindex="-1" role="dialog" aria-labelledby="edit-dynamic-block-label" aria-hidden="true">
        <div class="modal-dialog" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title"">Edit Block</h5>
                        <button type=" button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                        </button>
                </div>
                <form>
                    <div class="modal-body">
                        <div class="form-group">
                            <label>Block Name (*)</label>
                            <input type="text" name="block_name" id="edit_block_name" class="form-control" disabled readonly required>
                            <input type="hidden" id="edit_block_key">
                            <input type="hidden" id="edit_block_pid">
                        </div>
                        <div class="form-group">
                            <label>Id Attribute</label>
                            <input type="text" name="block_id" id="edit_block_id" class="form-control">
                        </div>
                        <div class="form-group">
                            <label>Class Attribute</label>
                            <input type="text" name="block_class" id="edit_block_class" class="form-control">
                        </div>
                        <div class="form-group">
                            <label>Column</label>
                            <select class="form-control" name="cols" id="edit_block_cols">
                                <option value="1">1</option>
                                <option value="2">2</option>
                                <option value="3">3</option>
                                <option value="4">4</option>
                            </select>
                        </div>
                    </div>
                    <div class="modal-footer">
                        <button type="button" class="btn btn-secondary" data-dismiss="modal">Close</button>
                        <button type="submit" class="btn btn-primary">Update</button>
                    </div>
                </form>
            </div>
        </div>
    </div>
    

<?php $__env->stopSection(); ?>
<?php $__env->startPush('after-scripts'); ?>
    <script>
         $(function() {
            
            $(document).on('click', '#add-block', function(e) {
                e.preventDefault();
                
                var cols = $('#block_cols').val();
                var block = parseInt($('#block_count').val())+1;
                loading();
                $.ajax({
                    url: "<?php echo e(route('admin.dynamic.addblock')); ?>",
                    type: "GET",
                    data: {
                        cols: cols,
                        block: block,
                    },
                    success: function(data) {
                        $('#dynamic-block-container').append(data);
                        $('#block_count').val(block);
                    },
                    error: function() {

                    },
                    complete: function() {
                        // _this.find('button[type="submit"]').attr('disabled', false);
                        $('#dynamic-block-modal').modal('hide');
                        loading(false);
                    }

                });        
                
            });
            
            $(document).on('click', '.dynamic-block a', function(e) {
                e.preventDefault();
                var _this = $(this);
                var type = $(this).data('type');
                var col = $(this).data('col');
                var cols = $(this).data('cols');
                var block = $(this).data('block');
                var item = $(this).parent().data('item');
                loading();
                $.ajax({
                    url: "<?php echo e(route('admin.dynamic.block')); ?>",
                    type: "GET",
                    data: {
                        type: type,
                        col: col,
                        cols: cols,
                        block: block,
                        item: item
                    },
                    success: function(data) {
                        _this.closest('.dynamic-items-holder').find('.dynamic-block-items').append(data);
                        LARAPRESS.plugins.reload('textarea');
                        _this.parent().data('item', item+1);
                    },
                    error: function() {

                    },
                    complete: function() {
                        loading(false);
                    }
                });      
                
            });

            $(document).on('click', '.delete-block-item', function(e) {
                e.preventDefault();
                var delete_block_url ="<?php echo e(route('admin.dynamic.block.delete')); ?>";
                var key =  $(this).data('key');  
                var pid =  $(this).data('pid'); 
                Swal.fire({
                    title: 'Are you sure want to delete this block?',
                    showCancelButton: true,
                    confirmButtonText: 'Yes'
                }).then((result) => {
                    if (result.isConfirmed) { 
                        if(pid) {
                            loading();
                            $.post(delete_block_url, {pid: pid, key: key}, function(data) {
                                if(data['status']) {                    
                                    LARAPRESS.plugins.notify('success', 'Block has been deleted successfully.');
                                    $('#'+key).remove();
                                } else {
                                    LARAPRESS.plugins.notify('danger', 'Something went wrong.');
                                }
                                loading(false);
                            });
                        } else {
                            $('#'+key).remove();
                            LARAPRESS.plugins.notify('success', 'Block has been deleted successfully.');
                        }   
                    }
                });              
            });

            $(document).on('click', '.delete-meta-item', function(e) {
                e.preventDefault();
                var delete_block_url ="<?php echo e(route('admin.dynamic.block.item.delete')); ?>";
                var key =  $(this).data('key');
                var pid =  $(this).data('pid');
                var col =  $(this).data('col');
                var item =  $(this).data('item');
                Swal.fire({
                    title: 'Are you sure want to delete this block item?',
                    showCancelButton: true,
                    confirmButtonText: 'Yes'
                }).then((result) => {
                    if (result.isConfirmed) {                        
                        if(pid) {
                            loading();
                            $.post(delete_block_url, {pid: pid, key: key, col:col, item:item }, function(data) {
                                if(data['status']) {                    
                                    LARAPRESS.plugins.notify('success', 'Meta item has been deleted successfully.');
                                    var card =key+col+item;
                                    $('#'+card).remove();
                                } else {
                                    LARAPRESS.plugins.notify('danger', 'Something went wrong.');
                                }
                                loading(false);
                            });
                        } else {
                            var card =key+col+item;
                            $('#'+card).remove();
                            LARAPRESS.plugins.notify('success', 'Meta item has been deleted successfully.');
                        }  
                    }
                }); 
                              
            });

            $(document).on('click', '.sort-meta-item', function(e) {
                e.preventDefault();
                var sort_block_url ="<?php echo e(route('admin.dynamic.block.sort')); ?>";
                var key =  $(this).data('key');
                var pid =  $(this).data('pid');
                var sort =  $(this).data('sort');
                $.post(sort_block_url, {pid: pid, key: key, sort:sort }, function(data) {
                    if(data['status']) {                    
                        location.reload();
                    } else {
                        LARAPRESS.plugins.notify('danger', 'Something went wrong.');
                    }
                });
            });

            $('#edit-dynamic-block-modal form').on('submit', function(e) {
                e.preventDefault();
                var _this = $(this);
                $('#edit-dynamic-block-modal').modal('hide');
                $.ajax({
                    url: "<?php echo e(route('admin.dynamic.block.update')); ?>",
                    type: "GET",
                    data: {
                        key: $('#edit_block_key').val(),
                        pid: $('#edit_block_pid').val(),
                        id: $('#edit_block_id').val(),
                        class: $('#edit_block_class').val(),
                        cols: $('#edit_block_cols').val()
                    },

                    success: function(data) {
                        location.reload();
                    },
                    error: function() {

                    },
                    complete: function() {
                        _this.find('button[type="submit"]').attr('disabled', false);
                    }
                });
            });

            $(document).on('click', '#saveEdit', function(e) {
                $("<input>").attr({
                    name: "saveEdit",
                    id: "savenedit",
                    type: "hidden",
                    value: 'saveEdit'
                }).appendTo("#postForm");

                $('#postForm').submit();
            });

            $('#meta-title').on('keyup', function() {
                var length = $(this).val().length;
                if (length > 60) {
                    $('#meta_title_length').addClass('red');
                    $('#meta_title_length').removeClass('green');
                } else {
                    $('#meta_title_length').removeClass('red');
                    $('#meta_title_length').addClass('green');
                }
                $('#meta_title_length').html(length + ' characters');
            });

            $('#meta-description').on('keyup', function() {
                var length = $(this).val().length;
                if (length > 160) {
                    $('#meta_description_length').addClass('red');
                    $('#meta_description_length').removeClass('green');
                } else {
                    $('#meta_description_length').removeClass('red')
                    $('#meta_description_length').addClass('green');;
                }
                $('#meta_description_length').html(length + ' characters');
            });
        });
    </script>
<?php $__env->stopPush(); ?>

<?php echo $__env->make('admin.layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\laragon\www\arkbo\resources\views/admin/pages/edit.blade.php ENDPATH**/ ?>