

<?php $__env->startSection('title', 'Dashboard'); ?>

<?php $__env->startSection('page-header'); ?>
  <h1>
      <?php echo e(app_name()); ?>

      <small><?php echo e(trans('strings.backend.dashboard.title')); ?></small>
  </h1>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('after-styles'); ?>
  <style>
      .larapress-updates ul {
          padding-left: 15px;
      }

      .larapress-updates ul li {
          padding: 5px 0px;
      }
  </style>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('content'); ?>
  <div class="row">
      <div class="col-lg-3 col-md-3 col-xs-6">
          <!-- small box -->
          <div class="small-box bg-info">
              <div class="inner">
                  <h3><?php echo e($total_blogs); ?></h3>

                  <p>Total Blogs</p>
              </div>
              <div class="icon">
                  <i class="ion ion-document-text"></i>
              </div>
              <a href="#" class="small-box-footer">More info <i class="fa fa-arrow-circle-right"></i></a>
          </div>
      </div>
      <!-- ./col -->
      <div class="col-lg-3 col-md-3 col-xs-6">
          <!-- small box -->
          <div class="small-box bg-green">
              <div class="inner">
                  <h3><?php echo e($total_pages); ?></h3>

                  <p>Total Pages</p>
              </div>
              <div class="icon">
                  <i class="ion ion-android-list"></i>
              </div>
              <a href="#" class="small-box-footer">More info <i class="fa fa-arrow-circle-right"></i></a>
          </div>
      </div>
      <!-- ./col -->
      <div class="col-lg-3 col-md-3 col-xs-6">
          <!-- small box -->
          <div class="small-box bg-yellow">
              <div class="inner">
                  <h3><?php echo e($total_comments); ?></h3>

                  <p>Total Comments</p>
              </div>
              <div class="icon">
                  <i class="ion ion-chatboxes"></i>
              </div>
              <a href="#" class="small-box-footer">More info <i class="fa fa-arrow-circle-right"></i></a>
          </div>
      </div>
      <!-- ./col -->
      <div class="col-lg-3 col-md-3 col-xs-6">
          <!-- small box -->
          <div class="small-box bg-red">
              <div class="inner">
                  <h3 id="total_visitors">0</h3>

                  <p>Total Visitors of last 30 days</p>
              </div>
              <div class="icon">
                  <i class="ion ion-pie-graph"></i>
              </div>
              <a href="#" class="small-box-footer">More info <i class="fa fa-arrow-circle-right"></i></a>
          </div>
      </div>
      <!-- ./col -->
  </div>

  <div class="row">
      <div class="col-md-4">
          <div class="row">
              <div class="col-md-12">
                  <!-- Application buttons -->
                  <div class="card">
                      <div class="card-header">
                          <h3 class="card-title">Shortcut Links</h3>
                      </div>
                      <div class="card-body">

                          <a class="btn btn-app" href="<?php echo e(route('admin.blog.create')); ?>">
                              <i class="fa fa-plus"></i> Add Post
                          </a>
                          <a class="btn btn-app" href="<?php echo e(route('admin.blog.index')); ?>">
                              <i class="fa fa-file"></i> All Posts
                          </a>
                          <a class="btn btn-app" href="<?php echo e(route('admin.page.create')); ?>">
                              <i class="fa fa-plus"></i> Add Page
                          </a>
                          <a class="btn btn-app" href="<?php echo e(route('admin.page.index')); ?>">
                              <i class="fa fa-file"></i> All Pages
                          </a>

                      </div>
                      <!-- /.card-body -->
                  </div>
                  <!-- /.box -->
              </div>
              <div class="col-md-12">
                  <div class="card">
                      <div class="card-header with-border">
                          <h3 class="card-title"><?php echo e(trans('history.backend.recent_history')); ?></h3>
                          <div class="card-tools">
                              <button type="button" class="btn btn-tool" data-card-widget="collapse">
                                  <i class="fas fa-minus"></i>
                              </button>
                          </div>
                      </div><!-- /.card-header -->
                      <div class="card-body">
                          <?php echo history()->render(); ?>

                      </div><!-- /.card-body -->
                  </div>
                  <!--card-->
              </div>
          </div>
      </div>
      <div class="col-md-5">
          <div class="card">
              <div class="card-header with-border">
                  <h3 class="card-title">Recent Posts</h3>
                  <div class="card-tools">
                      <button type="button" class="btn btn-tool" data-card-widget="collapse">
                          <i class="fas fa-minus"></i>
                      </button>
                  </div>

              </div>
              <!-- /.card-header -->
              <div class="card-body">
                  <ul class="products-list product-list-in-box">
                      <?php
                          $blogs = posts($pagination = 4, ['user_id' => auth()->id()]);
                      ?>
                      <?php if($blogs): ?>
                          <?php $__currentLoopData = $blogs; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $blog): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                              <li class="item">
                                  <div class="product-img">
                                      <?php if($blog->getFeaturedImage($blog->media_id, true)): ?>
                                          <img src="<?php echo e($blog->featuredImage(true)); ?>" alt="<?php echo e($blog->title()); ?>">
                                      <?php endif; ?>
                                  </div>
                                  <div class="product-info">
                                      <a href="<?php echo e($blog->permalink()); ?>" class="product-title"><?php echo e($blog->title()); ?>

                                      </a>

                                  </div>
                              </li>
                          <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                      <?php endif; ?>
                      <!-- /.item -->
                  </ul>
              </div>
              <!-- /.card-body -->
              <div class="card-footer text-center">
                  <a href="<?php echo e(route('admin.blog.index')); ?>" class="uppercase">View All Posts</a>
              </div>
              <!-- /.card-footer -->
          </div>
      </div>
      <div class="col-md-3">
          <div class="card">
              <div class="card-header with-border">
                  <h3 class="card-title">Updates News</h3>
                  <div class="card-tools">
                      <button type="button" class="btn btn-tool" data-card-widget="collapse">
                          <i class="fas fa-minus"></i>
                      </button>
                  </div>
              </div><!-- /.card-header -->
              <div class="card-body" id="larapress-updates">

              </div><!-- /.card-body -->
          </div>
          <!--card box-success-->
      </div>


  </div>
<?php $__env->stopSection(); ?>
<?php $__env->startPush('after-scripts'); ?>
  <script>
      jQuery(document).ready(function() {
          $.ajax({
              type: "GET",
              url: base_url + '/admin/analytics',
              cache: true,
              dataType: "json",
              success: function(data) {
                  $("#total_visitors").html(data.total_page_views);
              }
          });

          $.ajax({
              type: "GET",
              url: "https://seshra.com/larapress/updates/list",
              cache: true,
              success: function(data) {
                  $("#larapress-updates").html(data);
              }
          });

      });
  </script>
<?php $__env->stopPush(); ?>

<?php echo $__env->make('admin.layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/asianelearning/public_html/resources/views/admin/dashboard.blade.php ENDPATH**/ ?>