<!-- Left side column. contains the logo and sidebar -->
<aside class="main-sidebar sidebar-dark-primary elevation-4">
    <!-- Brand Logo -->
    <a href="<?php echo e(route("admin.dashboard")); ?>" class="brand-link">
        <?php if(settings('site-logo')): ?>
            <span class="brand-text font-weight-light"><img src="<?php echo e(site_logo()); ?>" class="sidebar-brand-logo"></span>
        <?php elseif(settings('site-logo-dark')): ?>
            <span class="brand-text font-weight-light"><img src="<?php echo e(site_logo('dark')); ?>" class="sidebar-brand-logo"></span>
        <?php else: ?>
            <span class="brand-text font-weight-light"><img src="<?php echo e(public_asset('images/larapress/logo_invert.png')); ?>" class="sidebar-brand-logo"></span>
        <?php endif; ?>
      </a>
  
      <!-- Sidebar -->
    <section class="sidebar">
      <!-- Sidebar user panel (optional) -->
      <div class="user-panel mt-3 pb-3 mb-3 d-flex">
        <div class="image">
            <img src="<?php echo e(access()->user()->picture); ?>" class="img-circle elevation-2" alt="User Image">
        </div>
        <div class="info">
            <a href="<?php echo e(route('admin.user.profile')); ?>" class="d-block"><?php echo e(access()->user()->name); ?></a>
        </div>
      </div>

         <!-- Sidebar Menu -->
      <nav class="mt-2">
        <ul class="nav nav-pills nav-sidebar flex-column" data-widget="treeview" role="menu" data-accordion="false"  data-toggle="larapress-menu">
          <!-- Add icons to the links using the .nav-icon class
               with font-awesome or any other icon font library -->
               <?php $__currentLoopData = $menu->items; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $menuItem): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                 <?php if(isset($menuItem['permission']) && auth()->user()->hasPermission($menuItem['permission'])): ?>
                    <li class="larapress-nav-item nav-item <?php echo e(count($menuItem['children']) ? 'has-treeview' : ''); ?>">
                        <a href="<?php echo e(count($menuItem['children']) == 0 ? $menuItem['url'] : '#'); ?>" class="nav-link <?php echo e(are_active_routes($menuItem['routes'] ?? $menuItem['route'])); ?>">
                            <i class="nav-icon <?php echo e($menuItem['icon-class']); ?>"></i>
                            <p>
                                <?php echo e($menuItem['name']); ?>

                                <?php if(count($menuItem['children']) > 0): ?>
                                    <i class="right fas fa-angle-left"></i>
                                <?php endif; ?>
                            </p>
                        </a>
                        <?php if(count($menuItem['children']) > 0): ?>
                            <ul class="nav nav-treeview level-2">
                                <?php $__currentLoopData = $menuItem['children']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $subMenuItem): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <?php if(isset($subMenuItem['permission']) && auth()->user()->hasPermission($subMenuItem['permission'])): ?>
                                    <li class="nav-item">
                                        <a href="<?php echo e($subMenuItem['url']); ?>" class="nav-link <?php echo e(are_active_routes($subMenuItem['routes'])); ?>">
                                            <i class="far fa-circle nav-icon"></i>
                                            <p><?php echo e($subMenuItem['name']); ?></p>
                                        </a>
                                    </li>
                                    <?php endif; ?>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </ul>
                        <?php endif; ?>
                    </li>
                 <?php endif; ?>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </ul><!-- /.sidebar-menu -->
      </nav>
    </section><!-- /.sidebar -->
</aside>
 <?php /**PATH C:\laragon\www\arkbo\resources\views/admin/includes/sidebar.blade.php ENDPATH**/ ?>