<?php

 /**
  * Global Routes
  * Routes that are used between both frontend and backend.
  */

// Switch between the included languages
Route::get('lang/{lang}', 'LanguageController@swap');
// Route::get('storage', function() {
//     Artisan::call('storage:link'); 
// });

/*
 * Backend Routes
 * Namespaces indicate folder structure
 */
Route::group(['namespace' => 'Backend', 'prefix' => 'admin', 'as' => 'admin.', 'middleware' => 'admin'], function () {
    // 	*
    // 	 * These routes need view-backend permission
    // 	 * (good if you want to allow more than one group in the backend,
    // 	 * then limit the backend features by different roles or permissions)
    // 	 *
    // 	 * Note: Administrator has all permissions so you do not have to specify the administrator role everywhere.

    includeRouteFiles(__DIR__.'/Backend/');
});



/*
 * Frontend Routes
 * Namespaces indicate folder structure
 */
Route::get('/', 'Frontend\HomeController@index')->name('index');
if (config('access.INSTALLED')) {
    // if(setting('messenger-chat-display-page') == 'homepage' || setting('messenger-chat-display-page') == 'all'){
//     Route::get('/', 'Frontend\HomeController@index')->name('index')->middleware('messenger');
    // }
    // else{
    // }
    // if(setting('messenger-chat-display-page') == 'all' || setting('messenger-chat-display-page') == 'other'){
//     Route::group(['namespace' => 'Frontend', 'middleware' => 'messenger'], function () {
//         includeRouteFiles(__DIR__ . '/Frontend/');
//     });
    // }else{
    Route::group(['namespace' => 'Frontend'], function () {
        includeRouteFiles(__DIR__.'/Frontend/');
    });
// s}
} else {
    Route::group(['namespace' => 'Frontend'], function () {
        Route::group(['prefix' => 'install'], function () {
            Route::get('/', 'InstallController@index')->name('installer');
            Route::get('requirements', 'InstallController@requirements');
            Route::get('permissions', 'InstallController@permissions');
            Route::get('database', 'InstallController@database');
            Route::post('start-installation', 'InstallController@installation')->name('installation');
            Route::get('install', 'InstallController@install');
            Route::post('install', 'InstallController@install');
            Route::get('settings', 'InstallController@settings');
            Route::post('settings', 'InstallController@settingsSave');
            Route::get('email_settings', 'InstallController@settingsEmail');
            Route::post('email_settings', 'InstallController@settingsEmailSave');
            Route::get('complete', 'InstallController@complete');
            Route::get('error', 'InstallController@error');
        });
    });

    Route::get('{route}', function() {
        return redirect()->route('installer');
    });
}

/* ----------------------------------------------------------------------- */
