<?php

/**
 * Frontend Controllers
 * All route names are prefixed with 'frontend.'.
 */
Route::get('storage_link', function() {
    Artisan::call('storage:link');
});

Route::get('cache_clear', function() {
    Artisan::call('cache:clear');
});

Route::get('module_optimize', function() {
    Artisan::call('module:optimize');
});

Route::get('macros', 'FrontendController@macros')->name('macros');
Route::feeds();

/*
 * Installation Route
 */
if (!config('access.INSTALLED')) {
    Route::group(['prefix' => 'install'], function () {
        Route::get('/', 'InstallController@index')->name('installer');
        Route::get('requirements', 'InstallController@requirements');
        Route::get('permissions', 'InstallController@permissions');
        Route::get('database', 'InstallController@database');
        Route::post('start-installation', 'InstallController@installation')->name('installation');
        Route::get('install', 'InstallController@install');
        Route::post('install', 'InstallController@install');
        Route::get('settings', 'InstallController@settings');
        Route::post('settings', 'InstallController@settingsSave');
        Route::get('email_settings', 'InstallController@settingsEmail');
        Route::post('email_settings', 'InstallController@settingsEmailSave');
        Route::get('complete', 'InstallController@complete');
        Route::get('error', 'InstallController@error');
    });
}

/*
 * Blogs route
 */
Route::get('blogs', 'PostController@getBlogs')->name('posts');
Route::get('search', 'SearchController@search')->name('search');
Route::post('language', 'HomeController@changeLanguage')->name('language.change');
/*
 * Post Route
 */
Route::get('{post}', 'PostController@index')->name('post')->middleware('disqus');

/*
 * Comment Route
 */
Route::post('comment/submit', 'HomeController@submitComment')->name('comment.submit');

Route::post('contact/submit', 'HomeController@submitContact')->name('contact.submit');

Route::get('gallery/{slug}', 'HomeController@gallery')->name('gallery');
