<?php

Breadcrumbs::for('admin.page.index', function ($breadcrumbs) {
    $breadcrumbs->parent('admin.dashboard');
    $breadcrumbs->push(trans('menus.backend.page.management'), route('admin.page.index'));
});
Breadcrumbs::for('admin.page.create', function ($breadcrumbs) {
    $breadcrumbs->parent('admin.page.index');
    $breadcrumbs->push(trans('menus.backend.page.create'), route('admin.page.create'));
});

Breadcrumbs::for('admin.page.edit', function ($breadcrumbs, $id) {
    $breadcrumbs->parent('admin.page.index');
    $breadcrumbs->push(trans('menus.backend.page.edit'), route('admin.page.edit', $id));
});

Breadcrumbs::for('admin.page.deleted', function ($breadcrumbs) {
    $breadcrumbs->parent('admin.page.index');
    $breadcrumbs->push(trans('menus.backend.page.deleted'), route('admin.page.deleted'));
});

Breadcrumbs::for('admin.custom.post.type', function ($trail, $type) {
    $trail->push(ucfirst($type), route('admin.custom.post.type', $type));
});

Breadcrumbs::for('admin.custom.post.type.create', function ($trail, $type) {
    $trail->push('Add '.ucfirst($type), route('admin.custom.post.type.create', $type));
});

Breadcrumbs::for('admin.custom.post.type.edit', function ($trail, $type, $page) {
    $trail->push('Edit '.ucfirst($type), route('admin.custom.post.type.edit', [$type, $page]));
});

Breadcrumbs::for('admin.custom.post.type.deleted', function ($trail, $type) {
    $trail->push('Deleted '.ucfirst($type), route('admin.custom.post.type.deleted', $type));
});

Breadcrumbs::for('admin.custom.post.type.category.create', function ($trail, $type) {
    $trail->push('Category', route('admin.custom.post.type.category.create', $type));
});
Breadcrumbs::for('admin.custom.post.type.category.edit', function ($trail, $type, $id) {
    $trail->push('Edit Category', route('admin.custom.post.type.category.edit', [$type, $id]));
});

Breadcrumbs::for('admin.theme.options', function ($trail) {
    $trail->push('ThemeOptions', route('admin.theme.options'));
});

Breadcrumbs::for('admin.theme.editor', function ($trail) {
    $trail->push('Theme Editor', route('admin.theme.editor'));
});