<?php

/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| This file is where you may define all of the routes that are handled
| by your module. Just tell Laravel the URIs it should respond
| to using a Closure or controller method. Build something great!
|
 */
Route::group([
    'prefix'     => 'media',
    'as'		 => 'media.',
    'middleware' => 'access.routeNeedsPermission:manage-media',
], function() {
    Route::get('/', 'MediaController@index')->name('index');
    Route::get('create', 'MediaController@create')->name('create');
    Route::post('store', 'MediaController@store')->name('store');
    Route::get('{id}/edit', 'MediaController@edit')->name('edit');
    Route::put('{id}/update', 'MediaController@update')->name('update');
    Route::put('{id}/update/details', 'MediaController@updateDetails')->name('update.details');
    Route::post('delete/{id}', 'MediaController@delete')->name('delete');

    Route::post('get', 'MediaController@getForDatatables')->name('get');
    Route::post('details', 'MediaController@mediaDetails')->name('details');
});

