<?php
/**
 * @author Rawbinn Shrestha <rawbinnn@gmail.com>
 */
if(config('gear.module.category')):
	/**
	 * Route for category management
	 */
    Route::group([
        'prefix'     => 'category',
        'as'         => 'category.',
        'middleware' => 'access.routeNeedsPermission:manage-categories',
    ], function() {
        //Route::get('/', 'CategoryController@index')->name('index');
        Route::get('create', 'CategoryController@create')->name('create');
        Route::post('create', 'CategoryController@store')->name('create');

        Route::get('{id}/edit', 'CategoryController@edit')->name('edit');
        Route::put('{id}/update', 'CategoryController@update')->name('update');
        Route::delete('{category}', 'CategoryController@delete')->name('delete');
     
        Route::post('deleteSelected', 'CategoryController@deleteSelected')->name('delete.selected');
    
    });
    
endif;