<?php
/**
 * @author Rawbinn Shrestha <rawbinnn@gmail.com>
 */

use Rawbinn\Larapress\Controllers\CustomPostTypeCategoryController;
use Rawbinn\Larapress\Controllers\CustomPostTypeController;
use Rawbinn\Larapress\Controllers\ThemeOptionController;

    /*
     * Routes for media upload [Recently not using this route. You can use if u need.]
     */
    //Route::get('media/browse', 'MediaController@index')->name('media.browse');
    //Route::post('media/uploading', 'MediaController@uploading')->name('media.uploading');

    Route::get('/', function () {
        return redirect()->to('admin/dashboard');
    });
    Route::get('analytics', 'DashboardController@analytics');

    Route::get('storage_link', 'DashboardController@storageLink');
    /*
     * Route for settings management
     */
    Route::group([
        'middleware' => 'access.routeNeedsPermission:manage-settings',
    ], function () {
        Route::get('setting/general', 'SettingController@general')->name('setting.general');
        Route::post('setting/general', 'SettingController@generalUpdate')->name('settings.general');

        Route::get('setting/social', 'SettingController@social')->name('setting.social');
        Route::post('setting/social', 'SettingController@socialUpdate')->name('settings.social');

        Route::get('setting/seo', 'SettingController@seo')->name('setting.seo');
        Route::post('setting/seo', 'SettingController@seoUpdate')->name('settings.seo');

        Route::get('setting/miscellaneous', 'SettingController@miscellaneous')->name('setting.miscellaneous');
        Route::post('setting/miscellaneous', 'SettingController@miscellaneousUpdate')->name('settings.miscellaneous.update');

        Route::get('setting/backup', 'SettingController@backup')->name('setting.backup');
        Route::post('setting/backup', 'SettingController@backupLarapress')->name('settings.backup');

        Route::get('setting/restore', 'SettingController@restore')->name('setting.restore');
        Route::post('setting/restore', 'SettingController@restoreLarapress')->name('settings.restore');

        Route::get('setting/custom_css', 'SettingController@customCss')->name('setting.custom_css');
        Route::post('setting/custom_css', 'SettingController@customCssUpdate')->name('settings.custom_css');
    });

    /*
     * Route for themes management
     */
    Route::group([
        'middleware' => 'access.routeNeedsPermission:manage-themes',
    ], function () {
        Route::get('themes', 'ThemeController@index')->name('themes.index');
        Route::post('themes/update', 'ThemeController@update')->name('themes.update');
        Route::post('themes/upload', 'ThemeController@upload')->name('themes.upload');

        Route::get('themeeditor', 'ThemeController@editor')->name('theme.editor');
        Route::post('themeeditor', 'ThemeController@updateEditor')->name('theme.editor');
        
    });

    Route::group([
        'middleware' => 'access.routeNeedsPermission:manage-theme-options',
    ], function () {
        Route::get('themeoptions', [ThemeOptionController::class, 'index'])->name('theme.options');
        Route::post('themeoptions', [ThemeOptionController::class, 'update'])->name('theme.options');
    });
   

    /*
     * Route for package management
     */
    Route::group([
        'middleware' => 'access.routeNeedsPermission:manage-packages',
    ], function () {
        Route::get('packages', 'PackageController@index')->name('packages.index');
        Route::post('package/upload', 'PackageController@upload')->name('package.upload');
        Route::delete('package/{package}/delete', 'PackageController@delete')->name('package.delete');
        Route::get('package/{package}/activate', 'PackageController@activate')->name('package.activate');
        Route::get('package/{package}/deactivate', 'PackageController@deactivate')->name('package.deactivate');
    });

    Route::get('post/{id}/edit', 'DashboardController@editPost')->name('post.edit');

    // Route::get('theme/editor/css', 'ThemeController@additionalCss');
    Route::get('dynamic/block/add', 'DynamicBlockController@addBlock')->name('dynamic.addblock');
    Route::get('dynamic/block', 'DynamicBlockController@getBlock')->name('dynamic.block');
    Route::get('dynamic/block/update', 'DynamicBlockController@updateBlock')->name('dynamic.block.update');
    Route::post('dynamic/block/item/delete', 'DynamicBlockController@deleteBlockItem')->name('dynamic.block.item.delete');
    Route::post('dynamic/block/delete', 'DynamicBlockController@deleteBlock')->name('dynamic.block.delete');
    Route::post('dynamic/block/sort', 'DynamicBlockController@sortBlock')->name('dynamic.block.sort');

    Route::get('type/{slug}', [CustomPostTypeController::class, 'index'])->name('custom.post.type');
    Route::get('type/{slug}/create', [CustomPostTypeController::class, 'create'])->name('custom.post.type.create');
    Route::post('type/{slug}/create', [CustomPostTypeController::class, 'store'])->name('custom.post.type.store');
    Route::get('type/{slug}/edit/{page}', [CustomPostTypeController::class, 'edit'])->name('custom.post.type.edit');
    Route::put('type/{slug}/edit/{page}', [CustomPostTypeController::class, 'update'])->name('custom.post.type.update');
    Route::delete('type/{slug}/destroy/{page}', [CustomPostTypeController::class, 'destroy'])->name('custom.post.type.destroy');
    Route::get('type/{slug}/deleted', [CustomPostTypeController::class, 'deleted'])->name('custom.post.type.deleted');
    Route::get('type/{slug}/restore/{page}', [CustomPostTypeController::class, 'restore'])->name('custom.post.type.restore');
    Route::get('type/{slug}/delete/{page}', [CustomPostTypeController::class, 'delete'])->name('custom.post.type.delete-permanently');
    Route::post('type/{slug}/deleteSelected', [CustomPostTypeController::class, 'deleteSelected'])->name('custom.post.type.deleteSelected');
    Route::post('type/{slug}/table', [CustomPostTypeController::class, 'getForDatatable'])->name('custom.post.type.datatable');

    Route::get('type/{slug}/category/create', [CustomPostTypeCategoryController::class, 'create'])->name('custom.post.type.category.create');
    Route::post('type/{slug}/category/create', [CustomPostTypeCategoryController::class, 'store'])->name('custom.post.type.category.store');
    Route::get('type/{slug}/category/{id}/edit', [CustomPostTypeCategoryController::class, 'edit'])->name('custom.post.type.category.edit');
    Route::put('type/{slug}/category/{id}/edit', [CustomPostTypeCategoryController::class, 'update'])->name('custom.post.type.category.update');