@extends('install.layout')
@section('content')
    {!! Form::open(array('url' =>  'install/settings', 'method' => 'post')) !!}
    <div class="step-content" style="padding-left: 15px; padding-top: 15px">
        <h3>{{trans('install.settings')}}</h3>
        <hr>
        <div id="one-school">
            <legend>{{trans('install.site_info')}}</legend>
            <div class="form-group required {{ $errors->has('title') ? 'has-error' : '' }}">
                <label for="title" class="col-sm-2">{{trans('install.site_title')}}</label>
                <div class="col-sm-10" style="text-align: left; ">
                    {!! Form::text('site_title', old('site_title'),array('class' => 'form-control input-sm')) !!}
                    <span class="help-block">{{ $errors->first('site_title', ':message') }}</span>
                </div>
            </div>
            <div class="form-group required {{ $errors->has('tagline') ? 'has-error' : '' }}">
                <label for="tagline" class="col-sm-2">{{trans('install.site_tagline')}}</label>
                <div class="col-sm-10" style="text-align: left; ">
                    {!! Form::text('site_tagline', old('site_tagline'),array('class' => 'form-control input-sm')) !!}
                    <span class="help-block">{{ $errors->first('site_tagline', ':message') }}</span>
                </div>
            </div>
            <div class="form-group required {{ $errors->has('email') ? 'has-error' : '' }}">
                <label for="email" class="col-sm-2">{{trans('install.site_email')}}</label>
                <div class="col-sm-10" style="text-align: left; ">
                    {!! Form::email('site_email', old('site_email'),array('class' => 'form-control input-sm')) !!}
                    <span class="help-block">{{ $errors->first('site_email', ':message') }}</span>
                </div>
            </div>
            <div class="form-group required {{ $errors->has('phone') ? 'has-error' : '' }}">
                <label for="phone" class="col-sm-2">{{trans('install.site_phone')}}</label>
                <div class="col-sm-10" style="text-align: left; ">
                    {!! Form::text('site_phone', old('site_phone'),array('class' => 'form-control input-sm')) !!}
                    <span class="help-block">{{ $errors->first('site_phone', ':message') }}</span>
                </div>
            </div>
            <div class="form-group required {{ $errors->has('address') ? 'has-error' : '' }}">
                <label for="address" class="col-sm-2">{{trans('install.site_address')}}</label>
                <div class="col-sm-10" style="text-align: left; ">
                    {!! Form::text('site_address', old('site_address'),array('class' => 'form-control input-sm')) !!}
                    <span class="help-block">{{ $errors->first('site_address', ':message') }}</span>
                </div>
            </div>
        </div>
        <legend id="admin">{{trans('install.super_admin')}}</legend>
        <div class="form-group required {{ $errors->has('first_name') ? 'has-error' : '' }}">
            <label for="first_name" class="col-sm-2">{{trans('install.first_name')}}</label>
            <div class="col-sm-10" style="text-align: left; ">
                {!! Form::text('first_name', old('first_name'),array('class' => 'form-control input-sm')) !!}
                <small>{{trans('install.first_name_info')}}</small>
                <span class="help-block">{{ $errors->first('first_name', ':message') }}</span>
            </div>
        </div>
        <div class="form-group required {{ $errors->has('last_name') ? 'has-error' : '' }}">
            <label for="last_name" class="col-sm-2">{{trans('install.last_name')}}</label>
            <div class="col-sm-10" style="text-align: left; ">
                {!! Form::text('last_name', old('last_name'),array('class' => 'form-control input-sm')) !!}
                <small>{{trans('install.last_name_info')}}</small>
                <span class="help-block">{{ $errors->first('last_name', ':message') }}</span>
            </div>
        </div>
        <div class="form-group required {{ $errors->has('email') ? 'has-error' : '' }}">
            <label for="email" class="col-sm-2">{{trans('install.email')}}</label>
            <div class="col-sm-10" style="text-align: left; ">
                {!! Form::email('email', old('email'),array('class' => 'form-control input-sm')) !!}
                <small>{{trans('install.email_info')}}</small>
                <span class="help-block">{{ $errors->first('email', ':message') }}</span>
            </div>
        </div>
        <div class="form-group required {{ $errors->has('password') ? 'has-error' : '' }}">
            <label for="password" class="col-sm-2">{{trans('install.password')}}</label>
            <div class="col-sm-10" style="text-align: left; ">
                {!! Form::password('password', array('class' => 'form-control input-sm')) !!}
                <small>{{trans('install.password_info2')}}</small>
                <span class="help-block">{{ $errors->first('password', ':message') }}</span>
            </div>
        </div>
        <div class="form-group required {{ $errors->has('password_confirmation') ? 'has-error' : '' }}">
            <label for="password" class="col-sm-2">{{trans('install.password_confirmation')}}</label>
            <div class="col-sm-10" style="text-align: left; ">
                {!! Form::password('password_confirmation', array('class' => 'form-control input-sm')) !!}
                <span class="help-block">{{ $errors->first('password_confirmation', ':message') }}</span>
            </div>
        </div>
        <button class="btn btn-green pull-right">
            {{trans('install.next')}}
            <i class="fa fa-arrow-right"></i>
        </button>
        <div class="clearfix"></div>
    </div>
    {!! Form::close() !!}
@stop