<!DOCTYPE html>
<html lang="en">
    <head>
        <meta charset="utf-8">
        <meta http-equiv="X-UA-Compatible" content="IE=edge">
        <meta name="viewport" content="width=device-width, initial-scale=1">
        <title>{{trans('install.installation')}} | Larapress</title>

        <!-- CSS -->
        <link rel="stylesheet" type="text/css" href="http://fonts.googleapis.com/css?family=Roboto:400,100,300,500">
        <link rel="stylesheet" type="text/css" href="{{public_asset('installer/bootstrap/css/bootstrap.min.css')}}">
        <link rel="stylesheet" type="text/css" href="{{public_asset('installer/font-awesome/css/font-awesome.min.css')}}">
		<link rel="stylesheet" type="text/css" href="{{public_asset('installer/css/form-elements.css')}}">
        <link rel="stylesheet" type="text/css" href="{{public_asset('installer/css/style.css')}}">

        <!-- HTML5 Shim and Respond.js IE8 support of HTML5 elements and media queries -->
        <!-- WARNING: Respond.js doesn't work if you view the page via file:// -->
        <!--[if lt IE 9]>
            <script src="https://oss.maxcdn.com/libs/html5shiv/3.7.0/html5shiv.js"></script>
            <script src="https://oss.maxcdn.com/libs/respond.js/1.4.2/respond.min.js"></script>
        <![endif]-->

        <!-- Favicon and touch icons -->
        <link rel="shortcut icon" href="{{asset('installer/ico/favicon.png')}}">
        <link rel="apple-touch-icon" sizes="72x72" href="{{public_asset('images/favicon/apple-icon-72x72.png')}}">
        <link rel="apple-touch-icon" sizes="76x76" href="{{public_asset('images/favicon/apple-icon-76x76.png')}}">
        <link rel="apple-touch-icon" sizes="114x114" href="{{public_asset('images/favicon/apple-icon-114x114.png')}}">
        <link rel="apple-touch-icon" sizes="120x120" href="{{public_asset('images/favicon/apple-icon-120x120.png')}}">
        <link rel="apple-touch-icon" sizes="144x144" href="{{public_asset('images/favicon/apple-icon-144x144.png')}}">
        <link rel="icon" type="image/png" sizes="192x192"  href="{{public_asset('images/favicon/android-icon-192x192.png')}}">
        <link rel="icon" type="image/png" sizes="32x32" href="{{public_asset('images/favicon/favicon-32x32.png')}}">
        <link rel="icon" type="image/png" sizes="96x96" href="{{public_asset('images/favicon/favicon-96x96.png')}}">
        <link rel="icon" type="image/png" sizes="16x16" href="{{public_asset('images/favicon/favicon-16x16.png')}}">
       <script>
           var base_url = "{{URL::to('/')}}";
        </script>
    </head>

    <body>

		<!-- Top menu -->
		<nav class="navbar navbar-inverse navbar-no-bg" role="navigation">
			<div class="container">
				<div class="navbar-header">
					<button type="button" class="navbar-toggle collapsed" data-toggle="collapse" data-target="#larapress">
						<span class="sr-only">Toggle navigation</span>
						<span class="icon-bar"></span>
						<span class="icon-bar"></span>
						<span class="icon-bar"></span>
					</button>
					<a class="navbar-brand" href="https://larapress.seshra.com">Larapress</a>
				</div>
				<!-- Collect the nav links, forms, and other content for toggling -->
				<div class="collapse navbar-collapse" id="larapress">
					<ul class="nav navbar-nav navbar-right">
						<li>
							<span class="li-social">
								<a href="https://www.facebook.com/seshrainnovation" target="_blank"><i class="fa fa-facebook"></i></a>
								<a href="https://github.com/rawbinn" target="_blank"><i class="fa fa-github"></i></a>
							</span>
						</li>
					</ul>
				</div>
			</div>
		</nav>

        <!-- Top content -->
        <div class="top-content">
            <div class="container">
                
                <div class="row">
                    <div class="col-sm-10 col-md-12 col-lg-12 form-box f1">
                        <img src="{{public_asset('images/larapress/logo_small.png')}}"><br>
                        <h3 style="border-top: 1px solid #aeaeae; display: inline-block; margin-top: 10px; padding-top: 10px;">Installation</h3>
                        @include('install.steps')
                        @yield('content')
                    </div>
                </div>
                    
            </div>
        </div>


        <!-- Javascript -->
        <script src="{{public_asset('installer/js/jquery-1.11.1.min.js')}}"></script>
        <script src="{{public_asset('installer/bootstrap/js/bootstrap.min.js')}}"></script>
        <script src="{{public_asset('installer/js/jquery.backstretch.min.js')}}"></script>
        <script src="{{public_asset('installer/js/retina-1.1.0.min.js')}}"></script>
        <script>        
            /*
                Fullscreen background
            */
            $.backstretch(base_url+"/public/installer/img/backgrounds/1.jpg");
            
        </script>
        <script src="{{public_asset('installer/js/scripts.js')}}"></script>

    </body>

</html>