<!DOCTYPE html>
<html lang="en">
    <head>
        <meta charset="utf-8">
        <meta http-equiv="X-UA-Compatible" content="IE=edge">
        <meta name="viewport" content="width=device-width, initial-scale=1">
        <meta name="csrf-token" content="{{ csrf_token() }}">

        <title>@yield('title', setting('site-title','Larapress'))</title>

        <!-- Meta -->
        <meta name="description" content="@yield('meta_description', 'Larapress')">
        <meta name="author" content="@yield('meta_author', 'rawbinnn@gmail.com')">
        @yield('meta')

        <!-- Styles -->
        @yield('before-styles')

        {{ Html::style('css/frontend.css') }}

        @yield('after-styles')

        <!-- Scripts -->
        <script>
            window.Laravel = <?php echo json_encode([
                'csrfToken' => csrf_token(),
            ]); ?>
        </script>
    </head>
    <body id="app-layout">
        <div id="app">
            @include('includes.partials.logged-in-as')
            @include('frontend.includes.nav')

            <div class="container">
                @include('includes.partials.messages')
                @yield('content')
            </div><!-- container -->
        </div><!--#app-->

        <!-- Scripts -->
        @yield('before-scripts')
        {!! Html::script('js/frontend.js') !!}
        @yield('after-scripts')

        @include('includes.partials.ga')
    </body>
</html>