@extends ('admin.layouts.app')

@section ('title', trans('labels.backend.sliderItems.management') . ' | ' . trans('labels.backend.slider.create'))

@section('page-header')
    <h1>
        {{ trans('labels.backend.sliderItems.management') }}
        <small>{{ trans('labels.backend.sliderItems.create') }}</small>
    </h1>
@endsection

@section('content')
   {{ Form::model($sliderItem,['route' => ['admin.slider.item.update', $sliderItem->id], 'role' => 'form', 'method' => 'put']) }}

        <div class="card">
            <div class="card-header with-border">
                <h3 class="card-title">Edit Item of Slide</h3>

                <div class="card-tools float-right">
                    <!-- Include your header buttons -->
                    <a href="{{route('admin.slider.item.create', $sliderItem->slider_id)}}" class="btn btn-sm btn-info float-right">Back to Add Slide</a>
                </div><!--card-tools float-right-->
            </div><!-- /.card-header -->

            <div class="card-body">
                <div class="form-group">
                    {{ Form::label('title', trans('validation.attributes.backend.sliderItems.title')) }}
                    {{ Form::text('title', null, ['class' => 'form-control', 'placeholder' => trans('validation.attributes.backend.sliderItems.title')]) }}
                </div><!--form group-->
                <div class="form-group">
                    {{ Form::label('description', trans('validation.attributes.backend.sliderItems.description')) }}
                     {{ Form::textarea('description', null, ['class' => 'form-control','rows' => '5']) }}
                </div><!--form group-->

                <div class="form-group">
                    <label for="site-logo">Slider Image</label>
                    <div class="input-group" data-toggle="seshra-uploader" data-type="image" data-group="sliders">
                        <div class="input-group-prepend">
                            <div class="input-group-text bg-soft-secondary font-weight-medium">Browse</div>
                        </div>
                        <div class="form-control file-amount">Choose File</div>
                        <input type="hidden" name="media_id" class="selected-files" value="{{$sliderItem->media_id}}">
                    </div>
                    <div class="file-preview box sm">
                    </div>
                </div><!--form group-->
            </div><!-- /.card-body -->
        </div><!--box-->

        <div class="card">
            <div class="card-body">
                <div class="float-left">
                    {{ link_to_route('admin.slider.index', trans('buttons.general.cancel'), [], ['class' => 'btn btn-danger btn-xs']) }}
                </div><!--float-left-->

                <div class="float-right">
                    {{ Form::submit(trans('buttons.general.crud.update'), ['class' => 'btn btn-success btn-xs']) }}
                </div><!--float-right-->

                <div class="clearfix"></div>
            </div><!-- /.card-body -->
        </div><!--box-->

    {{ Form::close() }}
@endsection

@push('after-scripts')
@endpush
