@extends ('admin.layouts.app')

@section ('title', trans('labels.backend.slider.management') . ' | ' . trans('labels.backend.slider.create'))

@section('page-header')
    <h1>
        {{ trans('labels.backend.slider.management') }}
        <small>{{ trans('labels.backend.slider.create') }}</small>
    </h1>
@endsection

@section('content')
   {{ Form::model($slider,['route' => ['admin.slider.update', $slider->id], 'role' => 'form', 'method' => 'put']) }}

        <div class="card">
            <div class="card-header with-border">
                <h3 class="card-title">{{ trans('labels.backend.slider.create') }}</h3>

                <div class="card-tools float-right">
                    <!-- Include your header buttons -->
                </div><!--card-tools float-right-->
            </div><!-- /.card-header -->

            <div class="card-body">
                <div class="form-group">
                    {{ Form::label('name', trans('validation.attributes.backend.slider.name')) }}
                    {{ Form::text('name', null, ['class' => 'form-control', 'placeholder' => trans('validation.attributes.backend.slider.name')]) }}
                </div><!--form control-->

                <div class="form-group">
                    
                </div><!--form control-->
            </div><!-- /.card-body -->
        </div><!--box-->

        <div class="card">
            <div class="card-body">
                <div class="float-left">
                    {{ link_to_route('admin.slider.index', trans('buttons.general.cancel'), [], ['class' => 'btn btn-danger btn-xs']) }}
                </div><!--float-left-->

                <div class="float-right">
                    {{ Form::submit(trans('buttons.general.crud.update'), ['class' => 'btn btn-success btn-xs']) }}
                </div><!--float-right-->

                <div class="clearfix"></div>
            </div><!-- /.card-body -->
        </div><!--box-->

    {{ Form::close() }}
@stop
@push('after-scripts')
    {{-- {{ script('vendor/ckeditor/adapters/jquery.js') }} --}}
    <script src="https://cdnjs.cloudflare.com/ajax/libs/tinymce/4.8.2/tinymce.min.js"></script>
    {{ script('vendor/laravel-filemanager/js/stand-alone-button.js') }}
    <script>
        /* $('[data-toggle="receivemoney-add-more"]').each(function() {
                                    var $this = $(this);
                                    $this.on("click", function(e) {
                                        e.preventDefault();
                                        var i = Math.floor(Math.random() * 99) + Math.random().toString(36).substring(2);
                                        var content =
                                            '<div class="row gutters-5"><div class="col-2"><div class="form-group"><div class="input-group"><span class="input-group-btn"><a id="receivemoney" data-input="receivemoney_thumbnail_' +
                                            i + '" data-mediaid="receivemoney_image_' + i + '" data-preview="receivemoney_holder_' +
                                            i +
                                            '" class="btn btn-default browse-image"> <i class="fa fa-image"></i> Choose </a></span> <input id="receivemoney_thumbnail_' +
                                            i +
                                            '" class="form-control" type="hidden" value="0" name="setting[receivemoney][receivemoney_url][]"> <input id="receivemoney_image_' +
                                            i +
                                            '" class="form-control" type="hidden" value="0" name="setting[receivemoney][image][]"> </div><div class="preview_box"><div id="receivemoney_holder_' +
                                            i +
                                            '"><img src="" style="margin-top:15px;max-height:100px;"></div></div></div></div>  <div class="col-4"><div class="form-group"><textarea class="form-control" placeholder="Description" name="setting[receivemoney][description][]"></textarea></div></div><div class="col-5"><div class="form-group"><textarea class="form-control" placeholder="Link" name="settings[receivemoney][link][]"></textarea></div></div><div class="col-1"><button type="button" class="mt-1 btn btn-circle btn-sm btn-danger" data-toggle="remove-parent" data-parent=".row"><i class="fa fa-times"></i></button></div></div>';
                                        var target = $this.data("target");
                                        $(target).append(content);
                                        $('.browse-image').filemanager('image', {
                                            prefix: url
                                        });
                                    });
                                }); */

        $('[data-toggle="sendmoney-add-more"]').each(function() {
            var $this = $(this);
            $this.on("click", function(e) {
                e.preventDefault();
                var i = Math.floor(Math.random() * 99) + Math.random().toString(36).substring(2);
                var content =
                    '<div class="row gutters-5"><div class="col-2"><div class="form-group"><div class="input-group"><span class="input-group-btn"><a id="sendmoney" data-input="sendmoney_thumbnail_' +
                    i + '" data-mediaid="sendmoney_image_' + i + '" data-preview="sendmoney_holder_' + i +
                    '" class="btn btn-default browse-image"> <i class="fa fa-image"></i> Choose </a></span> <input id="sendmoney_thumbnail_' +
                    i +
                    '" class="form-control" type="hidden" value="0" name="settings[sendmoney][steps][media_url][]"> <input id="sendmoney_image_' +
                    i +
                    '" class="form-control" type="hidden" value="0" name="settings[sendmoney][steps][media_id][]"> </div><div class="preview_box"><div id="sendmoney_holder_' +
                    i +
                    '"><img src="" style="margin-top:15px;max-height:100px;"></div></div></div></div>  <div class="col-4"><div class="form-group"><textarea class="form-control" placeholder="Description" name="settings[sendmoney][steps][description][]"> </textarea>     </div>              </div><div class="col-5"><div class="form-group"><button type="button" class="mt-1 btn btn-circle btn-sm btn-danger" data-toggle="remove-parent" data-parent=".row"><i class="fa fa-times"></i></button></div></div>';
                var target = $this.data("target");
                $(target).append(content);
                $('.browse-image').filemanager('image', {
                    prefix: url
                });
            });
        });
        $('[data-toggle="feature-add-more"]').each(function() {
            var $this = $(this);
            $this.on("click", function(e) {
                e.preventDefault();
                var i = Math.floor(Math.random() * 99) + Math.random().toString(36).substring(2);
                var content =
                    '<div class="row gutters-5"><div class="col-5"><div class="form-group"><input type="text" class="form-control" placeholder="Title" name="settings[whyus][items][title][]"></div></div><div class="col-6"><div class="form-group"><textarea class="form-control" placeholder="Description" name="settings[whyus][items][description][]"></textarea></div></div><div class="col-1"><button type="button" class="mt-1 btn btn-circle btn-sm btn-danger" data-toggle="remove-parent" data-parent=".row"><i class="fa fa-times"></i></button></div></div><div class="row gutters-5"><div class="col-12"><div class="form-group"><label for="content">Content</label></div></div></div>';
                var target = $this.data("target");
                $(target).append(content);
                $('.browse-image').filemanager('image', {
                    prefix: url
                });
            });
        });
        $(function() {

            var url = base_url + '/admin/filemanager';
            $('.browse-image').filemanager('image', {
                prefix: url
            });

            $('[data-toggle="add-more"]').each(function() {
                var $this = $(this);
                $this.on("click", function(e) {
                    e.preventDefault();
                    var i = Math.floor(Math.random() * 99) + Math.random().toString(36).substring(
                        2);
                    var content =
                        '<div class="row gutters-5"><div class="col-2"><div class="form-group"><div class="input-group"><span class="input-group-btn"><a id="key" data-input="key_thumbnail_' +
                        i + '" data-mediaid="banner_image_' + i + '" data-preview="key_holder_' +
                        i +
                        '" class="btn btn-default browse-image"> <i class="fa fa-image"></i> Choose </a></span> <input id="key_thumbnail_' +
                        i +
                        '" class="form-control" type="hidden" value="0" name="media_url"> <input id="banner_image_' +
                        i +
                        '" class="form-control" type="hidden" value="0" name="settings[receivemoney][steps][media_id][]"> </div><div class="preview_box"><div id="key_holder_' +
                        i +
                        '"><img src="" style="margin-top:15px;max-height:100px;"></div></div></div></div>  <div class="col-4"><div class="form-group"><input type="text" class="form-control" placeholder="Description" name="settings[receivemoney][steps][description][]">      </div>              </div><div class="col-1"><button type="button" class="mt-1 btn btn-circle btn-sm btn-danger" data-toggle="remove-parent" data-parent=".row"><i class="fa fa-times"></i></button></div></div>';
                    var target = $this.data("target");
                    $(target).append(content);
                    $('.browse-image').filemanager('image', {
                        prefix: url
                    });
                });
            });
            $('[data-toggle="bankaccount-add-more"]').each(function() {
                var $this = $(this);
                $this.on("click", function(e) {
                    e.preventDefault();
                    var i = Math.floor(Math.random() * 99) + Math.random().toString(36).substring(
                        2);
                    var content =
                        '<div class="row gutters-5"><div class="col-2"><div class="form-group"><div class="input-group"><span class="input-group-btn"><a id="bankaccount" data-input="bankaccount_thumbnail_' +
                        i + '" data-mediaid="bankaccount_image_' + i +
                        '" data-preview="bankaccount_holder_' +
                        i +
                        '" class="btn btn-default browse-image"> <i class="fa fa-image"></i> Choose </a></span> <input id="bankaccount_thumbnail_' +
                        i +
                        '" class="form-control" type="hidden" value="0" name="media_url"> <input id="bankaccount_image_' +
                        i +
                        '" class="form-control" type="hidden" value="0" name="settings[bankaccount][steps][media_id][]"> </div><div class="preview_box"><div id="bankaccount_holder_' +
                        i +
                        '"><img src="" style="margin-top:15px;max-height:100px;"></div></div></div></div>  <div class="col-4"><div class="form-group"><input type="text" class="form-control" placeholder="Description" name="settings[bankaccount][steps][description][]">      </div></div><div class="col-5"><div class="form-group"><textarea class="textarea" name="settings[bankaccount][steps][detail][]" value=""></textarea></div></div><div class="col-1"><button type="button" class="mt-1 btn btn-circle btn-sm btn-danger" data-toggle="remove-parent" data-parent=".row"><i class="fa fa-times"></i></button></div></div>';
                    var target = $this.data("target");
                    $(target).append(content);
                    $('.browse-image').filemanager('image', {
                        prefix: url
                    });
                });
            });

        });
        tinymce.init({
            selector: '.textarea',
            plugins: "code,link",
            toolbar: "undo redo |  formatselect | bold italic backcolor link | alignleft aligncenter alignright alignjustify | bullist numlist outdent indent | removeformat | code",
        });
        tinymce.init({
            selector: '#c7679',
            plugins: "code,link",
            toolbar: "undo redo |  formatselect | bold italic backcolor link | alignleft aligncenter alignright alignjustify | bullist numlist outdent indent | removeformat | code",
        });
        tinymce.init({
            selector: '#c76788',
            plugins: "code,link",
            toolbar: "undo redo |  formatselect | bold italic backcolor link | alignleft aligncenter alignright alignjustify | bullist numlist outdent indent | removeformat | code",
        });
        tinymce.init({
            selector: '#c7680',
            plugins: "code,link",
            toolbar: "undo redo |  formatselect | bold italic backcolor link | alignleft aligncenter alignright alignjustify | bullist numlist outdent indent | removeformat | code",
        });
        tinymce.init({
            selector: '#c767888',
            plugins: "code,link",
            toolbar: "undo redo |  formatselect | bold italic backcolor link | alignleft aligncenter alignright alignjustify | bullist numlist outdent indent | removeformat | code",
        });
        tinymce.init({
            selector: '#c7681',
            plugins: "code,link",
            toolbar: "undo redo |  formatselect | bold italic backcolor link | alignleft aligncenter alignright alignjustify | bullist numlist outdent indent | removeformat | code",
        });
    </script>
@endpush
