@extends ('admin.layouts.app')

@section ('title', trans('labels.backend.sliderItems.management'))

@section('after-styles')
        <!-- DataTables -->
  {{ style('vendor/datatables-bs4/css/dataTables.bootstrap4.min.css') }}
  {{ style('vendor/datatables-responsive/css/responsive.bootstrap4.min.css') }}
@stop

@section('page-header')
    <h1>
        {{ trans('labels.backend.sliderItems.management') }}
        <small>{{ trans('labels.backend.sliderItems.active') }}</small>
    </h1>
@endsection

@section('content')
    <div class="card">
        <div class="card-header with-border">
            <h3 class="card-title">{{ trans('labels.backend.sliderItems.active') }}</h3>

            <div class="card-tools float-right">
                <!-- Include your header buttons  -->
                <a href="{{route('admin.slider.item.create',$slider->id)}}" class="btn btn-success btn-xs">{{trans('menus.backend.sliderItems.create')}}</a>
                <a href="{{route('admin.slider.item.destroy', $slider->id)}}" class="btn btn-danger btn-xs">{{trans('menus.backend.sliderItems.deleted')}}</a>
                
            </div><!--card-tools float-right-->
        </div><!-- /.card-header -->

        <div class="card-body">
            <div class="table-responsive">
                <table id="sliders-table" class="table table-condensed table-hover">
                    <thead>
                    <tr>
                        <th>{{ trans('labels.backend.table.id') }}</th>
                        <th>{{ trans('labels.backend.table.title') }}</th>
                        <th>{{ trans('labels.backend.table.description') }}</th>
                        <th>Slide Image</th>
                        <th>{{ trans('labels.backend.table.created') }}</th>
                        <th>{{ trans('labels.general.actions') }}</th>
                    </tr>
                    </thead>
                </table>
            </div><!--table-responsive-->
        </div><!-- /.card-body -->
    </div><!--box-->

@stop

@push('after-scripts')
<!-- DataTables -->
    {{ script('vendor/datatables/jquery.dataTables.min.js') }}
    {{ script('vendor/datatables-bs4/js/dataTables.bootstrap4.min.js') }}

    <script>
        $(function() {
            var id = {{$slider->id}};
            $('#sliders-table').DataTable({
                processing: true,
                serverSide: true,
                iDisplayLength: 25,
                ajax: {
                    url: '{{ route("admin.slider.items.get") }}',
                    type: 'post',
                    data: {id: id, _token: Laravel.csrfToken}
                },
                columns: [
                    {data: 'id', name: 'id'},
                    {data: 'title', name: 'title'},
                    {data: 'description', name: 'description', searchable: false, sortable: false},
                    {data: 'image', name: 'image', searchable: false, sortable: false},
                    {data: 'created_at', name: 'created_at'},
                    {data: 'actions', name: 'actions', searchable: false, sortable: false}
                ],
                order: [[0, "asc"]],
                searchDelay: 500
            });
        });
    </script>
@endpush
