@extends ('admin.layouts.app')

@section('title', trans('labels.backend.settings.general'))

@section('page-header')
    <h1>
        {{ trans('labels.backend.settings.management') }}
        <small>{{ trans('labels.backend.settings.general') }}</small>
    </h1>
@endsection

@section('content')
    {{ Form::open(['route' => 'admin.setting.general', 'role' => 'form', 'method' => 'post']) }}

    <div class="card">
        <div class="card-header with-border">
            <h3 class="card-title">{{ trans('labels.backend.settings.general') }}</h3>

            <div class="card-tools float-right">
                <!-- Include your header buttons -->
            </div>
            <!--card-tools float-right-->
        </div><!-- /.card-header -->

        <div class="card-body">
            <div class="form-group">
                {{ Form::label('site-title', trans('validation.attributes.backend.settings.site-title')) }}
                {{ Form::text('site_title', setting('site-title'), ['class' => 'form-control','placeholder' => trans('validation.attributes.backend.settings.site-title')]) }}
            </div>
            <!--form control-->

            <div class="form-group">
                {{ Form::label('site-tagline', trans('validation.attributes.backend.settings.site-tagline')) }}
                {{ Form::text('site_tagline', setting('site-tagline'), ['class' => 'form-control','placeholder' => trans('validation.attributes.backend.settings.site-tagline')]) }}
            </div>
            <div class="form-group">
                {{ Form::label('site-email', trans('validation.attributes.backend.settings.site-email')) }}
                {{ Form::text('site_email', setting('site-email'), ['class' => 'form-control','placeholder' => trans('validation.attributes.backend.settings.site-email')]) }}
            </div>
            <div class="form-group">
                {{ Form::label('site-phone', trans('validation.attributes.backend.settings.site-phone')) }}
                {{ Form::text('site_phone', setting('site-phone'), ['class' => 'form-control','placeholder' => trans('validation.attributes.backend.settings.site-phone')]) }}
            </div>
           
            <div class="form-group">
                
                <div class="row">
                    <div class="col-md-6">
                        <label for="site-address">Address</label>
                        {{ Form::text('site_address', setting('site-address'), ['class' => 'form-control','placeholder' => trans('validation.attributes.backend.settings.site-address')]) }}
                    </div>
                    <div class="col-md-6">
                        <label for="site-address">Map Url</label>
                        {{ Form::text('site_address_url', setting('site-address-url'), ['class' => 'form-control','placeholder' => 'https://']) }}
                    </div>
                </div>
           </div>

            <div class="form-group">
                <label for="site-logo">Website Logo (Light)</label>
                <div class="form-group">                    
                    <div class="col-md-4">
                        <div class="input-group" data-toggle="seshra-uploader" data-type="image" data-group="logo">
                            <div class="input-group-prepend">
                                <div class="input-group-text bg-soft-secondary font-weight-medium">Browse</div>
                            </div>
                            <div class="form-control file-amount">Choose File</div>
                            <input type="hidden" name="site_logo" class="selected-files" value="{{setting('site-logo')}}">
                        </div>
                        <div class="file-preview box sm">
                            
                        </div>
                    </div>
                    
                </div>
            </div>
            <div class="form-group">
                <label for="site-logo">Website Logo (Dark)</label>
                <div class="form-group">
                    <div class="col-md-4">
                    <div class="input-group" data-toggle="seshra-uploader" data-type="image" data-group="logo">
                        <div class="input-group-prepend">
                            <div class="input-group-text bg-soft-secondary font-weight-medium">Browse</div>
                        </div>
                        <div class="form-control file-amount">Choose File</div>
                        <input type="hidden" name="site_logo_dark" class="selected-files" value="{{setting('site-logo-dark')}}">
                    </div>
                    <div class="file-preview box sm">
                    </div>
                    </div>
                </div>
            </div>            
            <div class="form-group">
                <label for="site-logo">Favicon</label>
                <div class="form-group">
                    <div class="col-md-4">
                    <div class="input-group" data-toggle="seshra-uploader" data-type="image" data-group="logo">
                        <div class="input-group-prepend">
                            <div class="input-group-text bg-soft-secondary font-weight-medium">Browse</div>
                        </div>
                        <div class="form-control file-amount">Choose File</div>
                        <input type="hidden" name="favicon" class="selected-files" value="{{setting('favicon')}}">
                    </div>
                    <div class="file-preview box sm">
                    </div>
                    </div>
                </div>
            </div>
        </div><!-- /.card-body -->
    </div>
    <!--box-->

    <div class="card">
        <div class="card-body">
            <div class="float-left">
                {{ link_to_route('admin.dashboard', trans('buttons.general.cancel'), [], ['class' => 'btn btn-danger btn-xs']) }}
            </div>
            <!--float-left-->

            <div class="float-right">
                {{ Form::submit(trans('buttons.general.crud.update'), ['class' => 'btn btn-success btn-xs']) }}
            </div>
            <!--float-right-->

            <div class="clearfix"></div>
        </div><!-- /.card-body -->
    </div>
    <!--box-->

    {{ Form::close() }}
@stop

@push('after-scripts')
    
@endpush
