@extends ('admin.layouts.app')

@section ('title', 'Custom CSS')

@section('page-header')
    <h1>
        Custom CSS
    </h1>
@endsection

@section('content')
    {{ Form::open(['route' => 'admin.setting.custom_css', 'role'=> 'form', 'method' => 'post']) }}

        <div class="card">
            <div class="card-header with-border">
                <h3 class="card-title">Additional CSS</h3>
            </div><!-- /.card-header -->

            <div class="card-body">
                <div class="form-group">
                    <textarea name="css" class="form-control" rows="20">{{$css}}</textarea>
                </div>
            </div><!-- /.card-body -->
        </div><!--box-->

        <div class="card">
            <div class="card-body">
                <div class="float-left">
                    {{ link_to_route('admin.dashboard', trans('buttons.general.cancel'), [], ['class' => 'btn btn-danger btn-xs']) }}
                </div><!--float-left-->

                <div class="float-right">
                    {{ Form::submit(trans('buttons.general.crud.update'), ['class' => 'btn btn-success btn-xs']) }}
                </div><!--float-right-->

                <div class="clearfix"></div>
            </div><!-- /.card-body -->
        </div><!--box-->

    {{ Form::close() }}
@stop
@push('after-scripts')

@endpush
