@extends ('admin.layouts.app')

@section ('title', trans('labels.backend.settings.backup_restore'))

@section('page-header')
    <h1>
        {{ trans('labels.backend.settings.management') }}
        <small>{{ trans('labels.backend.settings.backup') }}</small>
    </h1>
@endsection

@section('content')
    

        <div class="card">
            <div class="card-header with-border">
                <h3 class="card-title">{{ trans('labels.backend.settings.backup_restore') }}</h3>

                <div class="card-tools float-right">
                    <!-- Include your header buttons -->
                </div><!--card-tools float-right-->
            </div><!-- /.card-header -->

            <div class="card-body">
                {{ Form::open(['route' => 'admin.setting.backup', 'role'=> 'form', 'method' => 'post', 'onsubmit' => "return confirm('Are you sure?')"]) }}
                {{ Form::submit(trans('buttons.general.crud.backup'), ['class' => 'btn btn-default btn-sm']) }}

                {{ Form::close() }}
                <p></p>
                <button type="button" class="btn btn-default btn-sm">Restore (Coming Soon...)</button>
            </div><!-- /.card-body -->
        </div><!--box-->

@stop

@push('after-scripts')
{{ script('vendor/laravel-filemanager/js/stand-alone-button.js')}}
<script>
$(function () {
    var url = base_url + '/admin/filemanager';
    $('#sitelogo').filemanager('image',{prefix: url});
});
</script>
@endpush
