@extends ('admin.layouts.app')

@section ('title', 'Packages')

@section('after-styles')
<style>
.content {
    clear: both;
}
</style>
@stop

@section('page-header')
    <h1 style="float:left;">
        Packages
    </h1>
    <div class="package-upload">
        <form enctype="multipart/form-data" method="post" action="{{route('admin.package.upload')}}">
            {{csrf_field()}}
            <div class="row">
            <div class="col-md-5">
                <input type="file" name="package">
            </div>
            <div class="col-md-3">
                <button type="submit" class="btn btn-primary btn-xs">Upload</button>
            </div>
            </div>
        </form>
    </div>
@endsection

@section('content')
    <div class="card">
        <div class="card-header with-border">
            <h3 class="card-title">All Packages</h3>

            <div class="card-tools float-right">
                <!-- Include your header buttons  -->
               
            </div><!--card-tools float-right-->
        </div><!-- /.card-header -->

        <div class="card-body">
            <div class="table-responsive">
                <table id="packages-table" class="table table-condensed table-hover">
                    <thead>
                    <tr>
                        <th>Package</th>
                        <th>Description</th>
                        <th>Status</th>
                        <th>{{ trans('labels.general.actions') }}</th>
                    </tr>
                    </thead>
                    <tbody>
                    @foreach($modules as $module)
                        <tr>
                            <td>{{$module['name']}} {{$module['version']}}v</td>
                            <td>{{$module['description']}}</td>
                            <td>{{($module['enabled']) ? 'Enabled' : 'Disabled'}}</td>
                            <td>
                            @if($module['enabled'])
                                <a href="{{route('admin.package.deactivate', $module['slug'])}}" class="btn btn-warning btn-xs">Disable</a>
                            @else
                                <a href="{{route('admin.package.activate', $module['slug'])}}" class="btn btn-success btn-xs">Enable</a>
                            @endif
                            <a href="{{route('admin.package.delete', $module['slug']) }}"
                                        data-method="delete"
                                        data-trans-button-cancel="{{trans('buttons.general.cancel')}}"
                                        data-trans-button-confirm="{{trans('buttons.general.crud.delete')}}"
                                        data-trans-title="{{trans('strings.backend.general.are_you_sure')}}"
                                        class="btn btn-xs btn-danger"><i class="fa fa-trash" data-toggle="tooltip" data-placement="top" title="Trash"></i></a>
                            </td>
                        </tr>
                    @endforeach
                    </tbody>
                </table>
            </div><!--table-responsive-->
        </div><!-- /.card-body -->
    </div><!--box-->

@stop

@push('after-scripts')
@endpush
