@extends ('admin.layouts.app')

@section ('title', trans('labels.backend.media.all'))

@section('page-header')
    <h1>
        {{ trans('labels.backend.media.management') }}
        <small>{{ trans('labels.backend.media.all') }}</small>
    </h1>
@endsection
@section('after-styles')
<style>
    .modal-content{
        border-radius: 0px;
    }
    .image-loader{
        position: absolute;
        left:45%;
        top: 45%;
    }

</style>
@stop

@section('content')
<div class="col-md-12">
    <div class="card">
        <div class="card-header with-border">
            <div class="card-tools float-left">
               <a href=""><i class="fas fa-list"></i></a>
                <a href="{{url()->current()}}?display=grid"><i class="fas fa-border-all"></i></a>
                <select name="type" id="file-type-option">
                    <option value="all" {{Request::get('type')=='all' ? 'selected' : ''}}>All media items</option>
                    <option value="image" {{Request::get('type')=='image' ? 'selected' : ''}}>Image</option>
                    <option value="audio" {{Request::get('type')=='audio' ? 'selected' : ''}}>Audio</option>
                    <option value="video" {{Request::get('type')=='video' ? 'selected' : ''}}>Video</option>
                    <option value="pdf" {{Request::get('type')=='pdf' ? 'selected' : ''}}>PDFs</option>
                    <option value="doc" {{Request::get('type')=='doc' ? 'selected' : ''}}>DOC</option>
                </select>
                <select name="date" id="file-date-option">
                    <option value="all">All dates</option>
                    @foreach($dates as $date)
                        <option value="{{$date->year.'-'.$date->month}}" {{(Request::get('date') == ($date->year.','.$date->month)) ? 'selected' : ''}}>{{month($date->month)}} {{$date->year}}</option>
                    @endforeach
                </select>
                
            </div><!--card-tools float-right-->
            <div class="card-tools float-right">
                <input type="text" name="file_search" placeholder="Search media items...">
            </div>
        </div><!-- /.card-header -->
    </div><!--card-->
</div>
<div class="col-md-12">
    <div class="media-card">
        <ul tabindex="-1" class="attachments">
            @forelse($files as $file)
            <li tabindex="0" class="attachment" data-id="{{$file->id}}">
                <div class="attachment-preview {{$file->orientation}}">
                    <div class="thumbnail">				
                        
                        @if($file->type == 'image')
                        <div class="centered">                            
                            <img src="{{$file->url}}" class="image" />
                        </div>
                        @else
                        <div class="centered">                            
                            <img src="{{asset('images/document.png')}}" class="icon" alt="{{$file->alt}}" />
                        </div>
                        <div class="filename">
                            <div>{{$file->title}}</div>
                        </div>
                        @endif
                    
                </div>
                    
                </div>
            </li>
            @empty
            <li tabindex="0" class="attachment">No media file uploaded yet...</li>
            @endforelse
        </ul>
    </div>
</div>

<!-- Modal -->
<div class="modal fade" id="mediaModal" tabindex="-1" role="dialog" aria-labelledby="mediaModalCenterTitle" aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered modal-xl" role="document">
      <div class="modal-content">
        <div class="modal-header">
          <h5 class="modal-title" id="mediaModalLongTitle">Attachment Details</h5>
          <button type="button" class="close" data-dismiss="modal" aria-label="Close">
            <span aria-hidden="true">&times;</span>
          </button>
        </div>
        <div class="modal-body">
            <div class="container-fluid attachment-details">
                <div class="row">
                  <div class="col-md-8"><div id="imageholder"></div></div>
                  <div class="col-md-4">
                        <div class="form-group row">
                          <label for="title" class="col-sm-3 col-form-label">Title</label>
                          <div class="col-sm-9">
                            <input type="text" class="form-control" id="title" >
                          </div>
                        </div>
                        <div class="form-group row">
                          <label for="caption" class="col-sm-3 col-form-label">Caption</label>
                          <div class="col-sm-9">
                            <input type="text" class="form-control" id="caption">
                          </div>
                        </div>
                        <hr>
                        <div class="row">
                            <label for="file-name" class="col-sm-3 col-form-label">File name : </label>
                            <label for="file-name" class="col-sm-9 col-form-label" id="file-name"> </label>
                            
                          </div>
                          <div class="row">
                            <label for="file-type" class="col-sm-3 col-form-label">File type : </label>
                            <label for="file-type-value" class="col-sm-9 col-form-label" id="file-type"></label>
                          </div>
                          <div class="row">
                            <label for="uploaded-on" class="col-sm-3 col-form-label">Uploaded on : </label>
                            <label for="uploaded-value" class="col-sm-9 col-form-label" id="uploaded-on"></label>
                          </div>
                          <div class="row">
                            <label for="file-size" class="col-sm-3 col-form-label">File size : </label>
                            <label for="file-size-value" class="col-sm-9 col-form-label" id="file-size"></label>
                          </div>
                          <div class="row">
                            <label for="dimensions" class="col-sm-3 col-form-label">Dimensions : </label>
                            <label for="dimensions-value" class="col-sm-9 col-form-label" id="dimensions"></label>
                          </div>
                          <div class="row">
                            <label for="uploaded-by" class="col-sm-3 col-form-label">Uploaded By : </label>
                            <label for="uploaded-by-value" class="col-sm-9 col-form-label" id="uploaded-by"></label>
                          </div>
                          <div class="row">
                            <label for="copy-link" class="col-sm-3 col-form-label">Copy Link : </label>
                            <div class="col-sm-9">
                              <input type="text" readonly class="form-control" id="copy-link" value="">
                            </div>
                          </div>
                          <hr>
                          <p class="attachment-extra-links">
                            {{-- <a href="#">Edit more details</a> --}}
                            <a href="#" id="delete-permanently-link" class="text-danger">Delete Permanently</a>
                            
                        </p>
                  </div>
                </div>
              </div>
        </div>
      </div>
    </div>
  </div>
@stop
@push('after-scripts')
    <script>
        $(function() {
            var id;
           $(document).on('click', '.attachment', function(e){
                $('#mediaModal').modal('show');
                id = $(this).attr('data-id');
                $('#imageholder').html('');
                $('#imageholder').addClass('image-loader loader');
                $.ajax({
                    url: base_url+ '/admin/media/details',
                    type: 'POST',
                    dataType: 'json',
                    data: {id: id, _token: Laravel.csrfToken},
                })
                .done(function(data) {
                    $('#title').val(data.title);
                    $('#caption').val(data.caption);
                    $('#extension').html(data.extension);
                    $('#file-name').html(data.image);
                    $('#copy-link').val(data.path);
                    $('#file-size').html(data.file_size);
                    $('#file-type').html(data.filetype);
                    $('#dimensions').html(data.dimension);
                    $('#uploaded-by').html(data.uploaded_by);
                    $('#uploaded-on').html(data.created_at);
                    $('#delete-permanently-link').attr("href",base_url+'/admin/media/delete/'+data.image);
                    // if(data.orientation == 'landscape'){
                    //     $('#imageholder').html('<img src="'+data.path+'" width="100%">');
                    // }
                    // else{
                        $('#imageholder').html('<img src="'+data.path+'" style="max-height: 545px; width: 100%">');    
                    // }
                    $('#imageholder').removeClass('image-loader loader');
                })
                .fail(function() {
                    console.log("error");
                })
                .always(function() {
                    console.log("complete");
                });
            });

                $(document).on('click', '#delete-permanently-link', function(e){
                    e.preventDefault();
                    if(confirm('Are are about to permanently delete this item from your site.\nThis action cannot be undone.\n \'Cancel\' to stop, \'OK\' to delete.')){
                        $.ajax({url: $(this).attr('href'), method: 'POST'}).done(function(data) {location.reload()});
                    }
                })

                $(document).on('change', '#title', function(e){
                    e.preventDefault();
                    var title = $(this).val();
                    $( "#title" ).prop( "disabled", true );
                    $.ajax({
                        url: base_url+ '/admin/media/'+id+'/update/details',
                        type: 'POST',
                        dataType: 'json',
                        data: {title: title, _token: Laravel.csrfToken,_method:'PUT'},
                    })
                    .complete(function(data) {
                        $( "#title" ).prop( "disabled", false );
                    });
                });
                $(document).on('change', '#caption', function(e){
                    e.preventDefault();
                    var caption = $(this).val();
                    $( "#caption" ).prop( "disabled", true );
                    $.ajax({
                        url: base_url+ '/admin/media/'+id+'/update/details',
                        type: 'POST',
                        dataType: 'json',
                        data: {caption: caption, _token: Laravel.csrfToken,_method:'PUT'},
                    })
                    .complete(function(data) {
                        $( "#caption" ).prop( "disabled", false );
                    });
                });

                $('body').on('change', '#file-type-option', function(e){
                    e.preventDefault();
                    var type = $(this).val();
                    var date = "{{Request::has('date')? Request::get('date') : null}}";
                    var link = base_url+'/admin/media?type='+type;
                    if(date  != null){
                        window.location.href = link+'&date='+date;
                    }
                    else{
                        window.location.href = link;
                    }
                });

                $('body').on('change', '#file-date-option', function(e){
                    e.preventDefault();
                    var date = $(this).val();
                    var type = "{{Request::has('type')? Request::get('type') : null}}";
                    var link = base_url+'/admin/media';
                    if(type  != null){
                        window.location.href = link+'?type='+type+'&date='+date;
                    }
                    else{
                        window.location.href = link+'?date='+date;
                    }
                });
        });
    </script>
@endpush
