@extends ('admin.layouts.app')

@section ('title', 'Media Management | Edit Media')

@section('page-header')
    <h1>
        Media Management
        <small>Edit Media</small>
    </h1>
@endsection

@section('content')

<div class="col-md-7">
{{ Form::model($media,['route' => ['admin.media.update', $media->id], 'role' => 'form', 'method' => 'put', 'id' => 'media-form', 'enctype' => 'multipart/form-data']) }}
    <div class="card">
        <div class="card-header with-border">
            <h3 class="card-title">Edit Media</h3>

            <div class="card-tools float-right">
                <!-- Include your header buttons -->
            </div><!--card-tools float-right-->
        </div><!-- /.card-header -->

        <div class="card-body">
            <div class="form-group">
                {{ Form::label('title', 'Title') }}
                {{ Form::text('title', null, ['class' => 'form-control', 'id'=> 'block-title', 'placeholder' => 'Title', 'required']) }}
            </div><!--form control-->
            <input type="file" name="file">
            <p class="info">File Type: pdf, doc, docx </p>

            <div class="preview">
                @if($media->extension == 'pdf')
            <img src="{{asset('images/pdf.png')}}"><a href="{{$media->path}}">{{$media->title}}</a>
                @elseif($media->extension == 'doc' || $media->extension == 'docx')
                    <img src="{{asset('images/docx.png')}}"><a href="{{$media->path}}">{{$media->title}}</a>
                @endif
            </div>
        </div><!-- /.card-body -->
    </div><!--box-->
    <div class="card">
        <div class="card-body">
            <div class="float-left">
                {{ link_to_route('admin.media.index', trans('buttons.general.cancel'), [], ['class' => 'btn btn-danger btn-xs']) }}
            </div><!--float-left-->

            <div class="float-right">
                {{ Form::submit(trans('buttons.general.crud.update'), ['class' => 'btn btn-success btn-xs']) }}
            </div><!--float-right-->

            <div class="clearfix"></div>
        </div><!-- /.card-body -->
    </div><!--box-->

{{ Form::close() }}
</div>


@stop
@push('after-scripts')
    
@endpush

