@extends ('admin.layouts.app')

@section ('title', 'Create Media')

@section('page-header')
    <h1>
        Media Management
        <small>Add Media</small>
    </h1>
@endsection

@section('content')

<div class="col-md-7">
{{ Form::open(['route' => 'admin.media.store', 'role' => 'form', 'method' => 'post', 'id' => 'media-form', 'enctype' => 'multipart/form-data']) }}
    <div class="card">
        <div class="card-header with-border">
            <h3 class="card-title">Add Media</h3>

            <div class="card-tools float-right">
                <!-- Include your header buttons -->
            </div><!--card-tools float-right-->
        </div><!-- /.card-header -->

        <div class="card-body">
            <div class="form-group">
                {{ Form::label('title', 'Title') }}
                {{ Form::text('title', null, ['class' => 'form-control', 'id'=> 'block-title', 'placeholder' => 'Title', 'required']) }}
            </div><!--form control-->
            {{-- <input type="file" name="file">
            <p class="info">File Type: pdf, doc, docx </p> --}}
                    <div class="input-group" data-toggle="seshra-uploader" data-type="image" data-group="media">
                        <div class="input-group-prepend">
                            <div class="input-group-text bg-soft-secondary font-weight-medium">Browse</div>
                        </div>
                        <div class="form-control file-amount">Choose File</div>
                        <input type="hidden" name="media_id" class="selected-files">
                    </div>
                    <div class="file-preview box sm">
                    </div>
        </div><!-- /.card-body -->
    </div><!--box-->
    <div class="card">
        <div class="card-body">
            <div class="float-left">
                {{ link_to_route('admin.media.index', trans('buttons.general.cancel'), [], ['class' => 'btn btn-danger btn-xs']) }}
            </div><!--float-left-->

            <div class="float-right">
                {{ Form::submit(trans('buttons.general.crud.create'), ['class' => 'btn btn-success btn-xs']) }}
            </div><!--float-right-->

            <div class="clearfix"></div>
        </div><!-- /.card-body -->
    </div><!--box-->

{{ Form::close() }}
</div>


@stop

@push('after-scripts')

@endpush

