<!-- Left side column. contains the logo and sidebar -->
<aside class="main-sidebar sidebar-dark-primary elevation-4">
    <!-- Brand Logo -->
    <a href="{{route("admin.dashboard")}}" class="brand-link">
        @if(settings('site-logo'))
            <span class="brand-text font-weight-light"><img src="{{site_logo()}}" class="sidebar-brand-logo"></span>
        @elseif(settings('site-logo-dark'))
            <span class="brand-text font-weight-light"><img src="{{site_logo('dark')}}" class="sidebar-brand-logo"></span>
        @else
            <span class="brand-text font-weight-light"><img src="{{public_asset('images/larapress/logo_invert.png')}}" class="sidebar-brand-logo"></span>
        @endif
      </a>
  
      <!-- Sidebar -->
    <section class="sidebar">
      <!-- Sidebar user panel (optional) -->
      <div class="user-panel mt-3 pb-3 mb-3 d-flex">
        <div class="image">
            <img src="{{ access()->user()->picture }}" class="img-circle elevation-2" alt="User Image">
        </div>
        <div class="info">
            <a href="{{route('admin.user.profile')}}" class="d-block">{{access()->user()->name}}</a>
        </div>
      </div>

         <!-- Sidebar Menu -->
      <nav class="mt-2">
        <ul class="nav nav-pills nav-sidebar flex-column" data-widget="treeview" role="menu" data-accordion="false"  data-toggle="larapress-menu">
          <!-- Add icons to the links using the .nav-icon class
               with font-awesome or any other icon font library -->
               @foreach ($menu->items as $menuItem)
                 @if(isset($menuItem['permission']) && auth()->user()->hasPermission($menuItem['permission']))
                    <li class="larapress-nav-item nav-item {{ count($menuItem['children']) ? 'has-treeview' : '' }}">
                        <a href="{{ count($menuItem['children']) == 0 ? $menuItem['url'] : '#' }}" class="nav-link {{ are_active_routes($menuItem['routes'] ?? $menuItem['route']) }}">
                            <i class="nav-icon {{ $menuItem['icon-class'] }}"></i>
                            <p>
                                {{$menuItem['name']}}
                                @if(count($menuItem['children']) > 0)
                                    <i class="right fas fa-angle-left"></i>
                                @endif
                            </p>
                        </a>
                        @if(count($menuItem['children']) > 0)
                            <ul class="nav nav-treeview level-2">
                                @foreach($menuItem['children'] as $subMenuItem)
                                    @if(isset($subMenuItem['permission']) && auth()->user()->hasPermission($subMenuItem['permission']))
                                    <li class="nav-item">
                                        <a href="{{$subMenuItem['url']}}" class="nav-link {{ are_active_routes($subMenuItem['routes']) }}">
                                            <i class="far fa-circle nav-icon"></i>
                                            <p>{{ $subMenuItem['name'] }}</p>
                                        </a>
                                    </li>
                                    @endif
                                @endforeach
                            </ul>
                        @endif
                    </li>
                 @endif
                @endforeach
        </ul><!-- /.sidebar-menu -->
      </nav>
    </section><!-- /.sidebar -->
</aside>
 