@extends ('admin.layouts.app')

@section ('title', 'Gallery Management | Create Gallery')

@section('page-header')
    <h1>
        Gallery Management
        <small>View Gallery Images</small>
    </h1>
@endsection

@section('after-styles')
        <!-- DataTables -->
  {{ style('vendor/datatables-bs4/css/dataTables.bootstrap4.min.css') }}
  {{ style('vendor/datatables-responsive/css/responsive.bootstrap4.min.css') }}
@stop

@section('content')
   <div class="col-md-12">
          <div class="card">
            <div class="card-header with-border">
              <h3 class="card-title">Items of {{$gallery->title}} Gallery</h3>

              <div class="card-tools float-right">
                <a href="{{route('admin.gallery.item.create', $gallery->id)}}" class="btn btn-sm btn-primary">Add New Image</a>
              </div>
              <!-- /.card-tools -->
            </div>
            <!-- /.card-header -->
            <div class="card-body">
              <div class="table-responsive">
                <table id="gallery-table" class="table table-condensed table-hover">
                    <thead>
                    <tr>
                        <th>{{ trans('labels.backend.table.id') }}</th>
                        <th>{{ trans('labels.backend.table.title') }}</th>
                        <th>{{ trans('labels.backend.table.description') }}</th>
                        <th>Image</th>
                        <th>{{ trans('labels.backend.table.created') }}</th>
                        <th>{{ trans('labels.backend.table.last_updated') }}</th>
                        <th>{{ trans('labels.general.actions') }}</th>
                    </tr>
                    </thead>
                </table>
            </div><!--table-responsive-->
            </div>
            <!-- /.card-body -->
          </div>
          <!-- /.box -->
        </div>
@stop

@push('after-scripts')
<!-- DataTables -->
    {{ script('vendor/datatables/jquery.dataTables.min.js') }}
    {{ script('vendor/datatables-bs4/js/dataTables.bootstrap4.min.js') }}

    <script>
        $(function() {
            $('#gallery-table').DataTable({
                processing: true,
                serverSide: true,
                ajax: {
                    url: '{{ route("admin.gallery.items.get", $gallery->id) }}',
                    type: 'post',
                    data: {_token: Laravel.csrfToken}
                },
                columns: [
                    {data: 'id', name: 'id'},
                    {data: 'title', name: 'title'},
                    {data: 'description', name: 'description'},
                    {data: 'image', name: 'image'},
                    {data: 'created_at', name: 'created_at'},
                    {data: 'updated_at', name: 'updated_at'},
                    {data: 'actions', name: 'actions', searchable: false, sortable: false}
                ],
                order: [[0, "desc"]],
                searchDelay: 500
            });
        });
    </script>
@endpush

