@extends ('admin.layouts.app')

@section ('title', 'Gallery')

@section('after-styles')

@stop

@section('page-header')
    <h1>
        Gallery Management
    </h1>
@endsection

@section('content')
    <div class="card">
        <div class="card-header with-border">
            <h3 class="card-title">Gallery</h3>

            <div class="card-tools float-right">
                <!-- Include your header buttons  -->
                {{ link_to_route('admin.gallery.create','New Gallery', [], ['class' => 'btn btn-success btn-xs']) }}
            </div><!--card-tools float-right-->
        </div><!-- /.card-header -->

        <div class="card-body">
            <div class="table-responsive">
                <table id="gallery-table" class="table table-condensed table-hover">
                    <thead>
                    <tr>
                        <th>{{ trans('labels.backend.table.id') }}</th>
                        <th>{{ trans('labels.backend.table.title') }}</th>
                        <th>Items</th>
                        <th>Shortcode</th>
                        <th>{{ trans('labels.backend.table.created') }}</th>
                        <th>{{ trans('labels.general.actions') }}</th>
                    </tr>
                    </thead>
                    <tbody>
                        @forelse($galleries as $gallery)
                            <tr>
                                <td>{{$gallery->id}}</td>
                                <td>{{$gallery->title}}</td>
                                <td>{{$gallery->items()->count()}}</td>
                                <td>
                                    Shortcode: [gallery key={{$gallery->slug}}] <a href="#" class="clipboard" data-text="[gallery key={{$gallery->slug}}]">copy</a>
                                </td>
                                <td>{{$gallery->created_at->diffForHumans()}}</td>
                                <td>{!!$gallery->action_buttons!!}</td>
                            </tr>
                        @empty
                        <tr><td colspan="6" class="text-center">No data found...</td></tr>
                        @endforelse
                    </tbody>
                </table>
                {!! $galleries->links() !!}
            </div><!--table-responsive-->
        </div><!-- /.card-body -->
    </div><!--box-->

@stop

@push('after-scripts')
<script>
    $(document).on('click', '.clipboard', function(e) {
       var _this = $(this);
       var text = $(this).data('text');
       navigator.clipboard.writeText(text).then(() => {
           _this.text('copied');
       });
   });
</script>
@endpush
