@extends ('admin.layouts.app')

@section ('title', 'Edit Gallery')

@section('page-header')
    <h1>
        Gallery Management
    </h1>
@endsection
@push('after-scripts')

@endpush
@section('content')
    {{ Form::model($gallery, ['route' => ['admin.gallery.update', $gallery->id], 'role' => 'form', 'method' => 'put']) }}

        <div class="card">
            <div class="card-header with-border">
                <h3 class="card-title">Gallery</h3>

                <div class="card-tools float-right">
                    <!-- Include your header buttons -->
                </div><!--card-tools float-right-->
            </div><!-- /.card-header -->

            <div class="card-body">
                <div class="form-group">
                    {{ Form::label('title', 'Gallery Name') }}
                    {{ Form::text('title', null, ['class' => 'form-control', 'placeholder' => 'Name Your Gallery']) }}
                </div><!--form group-->
                <div class="form-group">
                    {{ Form::label('key', 'Key') }}
                    {{ Form::text('key', $gallery->slug, ['class' => 'form-control', 'placeholder' => 'Key', 'required']) }}
                </div><!--form group-->

                <div class="form-group">
                    {{ Form::label('gallery_images', 'Gallery Images') }}
                    <div class="gallery-image-row">
                        <div class="gallery-image-uploader" data-toggle="seshra-uploader" data-type="image" data-group="gallery" data-multiple="true">
                        <div class="gallery-uploader-box">
                        <i class="fas fa-image"></i><br>
                        <span class="gallery-uploader-text">Browse</span>
                        </div>
                        @php $image_ids = $gallery->items()->pluck('image_id')->toArray() @endphp
                        <input type="hidden" name="images" class="selected-files" value="{{implode(',', $image_ids)}}">
                        <input type="hidden" name="default_image" class="default-image">
                        </div>
                        <div class="file-preview"></div>
                    </div>
                </div>

            </div><!-- /.card-body -->
        </div><!--box-->

        <div class="card">
            <div class="card-body">
                <div class="float-left">
                    {{ link_to_route('admin.gallery.index', trans('buttons.general.cancel'), [], ['class' => 'btn btn-danger btn-xs']) }}
                </div><!--float-left-->

                <div class="float-right">
                    {{ Form::submit(trans('buttons.general.crud.update'), ['class' => 'btn btn-success btn-xs']) }}
                </div><!--float-right-->

                <div class="clearfix"></div>
            </div><!-- /.card-body -->
        </div><!--box-->

    {{ Form::close() }}
@stop

@push('after-scripts')
@endpush
